/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.OutpostResolver;
import software.amazon.awssdk.services.route53resolver.model.OutpostResolverListCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOutpostResolversResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListOutpostResolversResponse> {
    private static final SdkField<List<OutpostResolver>> OUTPOST_RESOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutpostResolvers").getter(ListOutpostResolversResponse.getter(ListOutpostResolversResponse::outpostResolvers)).setter(ListOutpostResolversResponse.setter(Builder::outpostResolvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostResolvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutpostResolver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOutpostResolversResponse.getter(ListOutpostResolversResponse::nextToken)).setter(ListOutpostResolversResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_RESOLVERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOutpostResolversResponse.memberNameToFieldInitializer();
    private final List<OutpostResolver> outpostResolvers;
    private final String nextToken;

    private ListOutpostResolversResponse(BuilderImpl builder) {
        super(builder);
        this.outpostResolvers = builder.outpostResolvers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOutpostResolvers() {
        return this.outpostResolvers != null && !(this.outpostResolvers instanceof SdkAutoConstructList);
    }

    public final List<OutpostResolver> outpostResolvers() {
        return this.outpostResolvers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutpostResolvers() ? this.outpostResolvers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutpostResolversResponse)) {
            return false;
        }
        ListOutpostResolversResponse other = (ListOutpostResolversResponse)((Object)obj);
        return this.hasOutpostResolvers() == other.hasOutpostResolvers() && Objects.equals(this.outpostResolvers(), other.outpostResolvers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOutpostResolversResponse").add("OutpostResolvers", this.hasOutpostResolvers() ? this.outpostResolvers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostResolvers": {
                return Optional.ofNullable(clazz.cast(this.outpostResolvers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutpostResolvers", OUTPOST_RESOLVERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOutpostResolversResponse, T> g) {
        return obj -> g.apply((ListOutpostResolversResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private List<OutpostResolver> outpostResolvers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutpostResolversResponse model) {
            super(model);
            this.outpostResolvers(model.outpostResolvers);
            this.nextToken(model.nextToken);
        }

        public final List<OutpostResolver.Builder> getOutpostResolvers() {
            List<OutpostResolver.Builder> result = OutpostResolverListCopier.copyToBuilder(this.outpostResolvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutpostResolvers(Collection<OutpostResolver.BuilderImpl> outpostResolvers) {
            this.outpostResolvers = OutpostResolverListCopier.copyFromBuilder(outpostResolvers);
        }

        @Override
        public final Builder outpostResolvers(Collection<OutpostResolver> outpostResolvers) {
            this.outpostResolvers = OutpostResolverListCopier.copy(outpostResolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostResolvers(OutpostResolver ... outpostResolvers) {
            this.outpostResolvers(Arrays.asList(outpostResolvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostResolvers(Consumer<OutpostResolver.Builder> ... outpostResolvers) {
            this.outpostResolvers(Stream.of(outpostResolvers).map(c -> (OutpostResolver)((OutpostResolver.Builder)OutpostResolver.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOutpostResolversResponse build() {
            return new ListOutpostResolversResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOutpostResolversResponse> {
        public Builder outpostResolvers(Collection<OutpostResolver> var1);

        public Builder outpostResolvers(OutpostResolver ... var1);

        public Builder outpostResolvers(Consumer<OutpostResolver.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

