/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.FirewallFailOpenStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(FirewallConfig.getter(FirewallConfig::id)).setter(FirewallConfig.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(FirewallConfig.getter(FirewallConfig::resourceId)).setter(FirewallConfig.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(FirewallConfig.getter(FirewallConfig::ownerId)).setter(FirewallConfig.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> FIREWALL_FAIL_OPEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallFailOpen").getter(FirewallConfig.getter(FirewallConfig::firewallFailOpenAsString)).setter(FirewallConfig.setter(Builder::firewallFailOpen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallFailOpen").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_ID_FIELD, OWNER_ID_FIELD, FIREWALL_FAIL_OPEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FirewallConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String resourceId;
    private final String ownerId;
    private final String firewallFailOpen;

    private FirewallConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceId = builder.resourceId;
        this.ownerId = builder.ownerId;
        this.firewallFailOpen = builder.firewallFailOpen;
    }

    public final String id() {
        return this.id;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final FirewallFailOpenStatus firewallFailOpen() {
        return FirewallFailOpenStatus.fromValue(this.firewallFailOpen);
    }

    public final String firewallFailOpenAsString() {
        return this.firewallFailOpen;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallFailOpenAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallConfig)) {
            return false;
        }
        FirewallConfig other = (FirewallConfig)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.firewallFailOpenAsString(), other.firewallFailOpenAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallConfig").add("Id", (Object)this.id()).add("ResourceId", (Object)this.resourceId()).add("OwnerId", (Object)this.ownerId()).add("FirewallFailOpen", (Object)this.firewallFailOpenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "FirewallFailOpen": {
                return Optional.ofNullable(clazz.cast(this.firewallFailOpenAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("FirewallFailOpen", FIREWALL_FAIL_OPEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirewallConfig, T> g) {
        return obj -> g.apply((FirewallConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String resourceId;
        private String ownerId;
        private String firewallFailOpen;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallConfig model) {
            this.id(model.id);
            this.resourceId(model.resourceId);
            this.ownerId(model.ownerId);
            this.firewallFailOpen(model.firewallFailOpen);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getFirewallFailOpen() {
            return this.firewallFailOpen;
        }

        public final void setFirewallFailOpen(String firewallFailOpen) {
            this.firewallFailOpen = firewallFailOpen;
        }

        @Override
        public final Builder firewallFailOpen(String firewallFailOpen) {
            this.firewallFailOpen = firewallFailOpen;
            return this;
        }

        @Override
        public final Builder firewallFailOpen(FirewallFailOpenStatus firewallFailOpen) {
            this.firewallFailOpen(firewallFailOpen == null ? null : firewallFailOpen.toString());
            return this;
        }

        public FirewallConfig build() {
            return new FirewallConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallConfig> {
        public Builder id(String var1);

        public Builder resourceId(String var1);

        public Builder ownerId(String var1);

        public Builder firewallFailOpen(String var1);

        public Builder firewallFailOpen(FirewallFailOpenStatus var1);
    }
}

