/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse;

public class ListResolverRulesPublisher
implements SdkPublisher<ListResolverRulesResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverRulesPublisher(Route53ResolverAsyncClient client, ListResolverRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverRulesPublisher(Route53ResolverAsyncClient client, ListResolverRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListResolverRulesPublisher resume(ListResolverRulesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResolverRulesPublisher(this.client, (ListResolverRulesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListResolverRulesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListResolverRulesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListResolverRulesResponseFetcher
    implements AsyncPageFetcher<ListResolverRulesResponse> {
        private ListResolverRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverRulesResponse> nextPage(ListResolverRulesResponse previousPage) {
            if (previousPage == null) {
                return ListResolverRulesPublisher.this.client.listResolverRules(ListResolverRulesPublisher.this.firstRequest);
            }
            return ListResolverRulesPublisher.this.client.listResolverRules((ListResolverRulesRequest)((Object)ListResolverRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

