/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupStatus;
import software.amazon.awssdk.services.route53resolver.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallRuleGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallRuleGroup> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(FirewallRuleGroup.getter(FirewallRuleGroup::id)).setter(FirewallRuleGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(FirewallRuleGroup.getter(FirewallRuleGroup::arn)).setter(FirewallRuleGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FirewallRuleGroup.getter(FirewallRuleGroup::name)).setter(FirewallRuleGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> RULE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleCount").getter(FirewallRuleGroup.getter(FirewallRuleGroup::ruleCount)).setter(FirewallRuleGroup.setter(Builder::ruleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FirewallRuleGroup.getter(FirewallRuleGroup::statusAsString)).setter(FirewallRuleGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(FirewallRuleGroup.getter(FirewallRuleGroup::statusMessage)).setter(FirewallRuleGroup.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(FirewallRuleGroup.getter(FirewallRuleGroup::ownerId)).setter(FirewallRuleGroup.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(FirewallRuleGroup.getter(FirewallRuleGroup::creatorRequestId)).setter(FirewallRuleGroup.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareStatus").getter(FirewallRuleGroup.getter(FirewallRuleGroup::shareStatusAsString)).setter(FirewallRuleGroup.setter(Builder::shareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(FirewallRuleGroup.getter(FirewallRuleGroup::creationTime)).setter(FirewallRuleGroup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationTime").getter(FirewallRuleGroup.getter(FirewallRuleGroup::modificationTime)).setter(FirewallRuleGroup.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, RULE_COUNT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, OWNER_ID_FIELD, CREATOR_REQUEST_ID_FIELD, SHARE_STATUS_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("RuleCount", RULE_COUNT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
            this.put("ShareStatus", SHARE_STATUS_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("ModificationTime", MODIFICATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final Integer ruleCount;
    private final String status;
    private final String statusMessage;
    private final String ownerId;
    private final String creatorRequestId;
    private final String shareStatus;
    private final String creationTime;
    private final String modificationTime;

    private FirewallRuleGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.ruleCount = builder.ruleCount;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.ownerId = builder.ownerId;
        this.creatorRequestId = builder.creatorRequestId;
        this.shareStatus = builder.shareStatus;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Integer ruleCount() {
        return this.ruleCount;
    }

    public final FirewallRuleGroupStatus status() {
        return FirewallRuleGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(this.shareStatus);
    }

    public final String shareStatusAsString() {
        return this.shareStatus;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String modificationTime() {
        return this.modificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallRuleGroup)) {
            return false;
        }
        FirewallRuleGroup other = (FirewallRuleGroup)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleCount(), other.ruleCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.shareStatusAsString(), other.shareStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modificationTime(), other.modificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallRuleGroup").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("RuleCount", (Object)this.ruleCount()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("OwnerId", (Object)this.ownerId()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("ShareStatus", (Object)this.shareStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("ModificationTime", (Object)this.modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleCount": {
                return Optional.ofNullable(clazz.cast(this.ruleCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "ShareStatus": {
                return Optional.ofNullable(clazz.cast(this.shareStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FirewallRuleGroup, T> g) {
        return obj -> g.apply((FirewallRuleGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private Integer ruleCount;
        private String status;
        private String statusMessage;
        private String ownerId;
        private String creatorRequestId;
        private String shareStatus;
        private String creationTime;
        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallRuleGroup model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.ruleCount(model.ruleCount);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.ownerId(model.ownerId);
            this.creatorRequestId(model.creatorRequestId);
            this.shareStatus(model.shareStatus);
            this.creationTime(model.creationTime);
            this.modificationTime(model.modificationTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getRuleCount() {
            return this.ruleCount;
        }

        public final void setRuleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
        }

        @Override
        public final Builder ruleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallRuleGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getShareStatus() {
            return this.shareStatus;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return this.modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public FirewallRuleGroup build() {
            return new FirewallRuleGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallRuleGroup> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder ruleCount(Integer var1);

        public Builder status(String var1);

        public Builder status(FirewallRuleGroupStatus var1);

        public Builder statusMessage(String var1);

        public Builder ownerId(String var1);

        public Builder creatorRequestId(String var1);

        public Builder shareStatus(String var1);

        public Builder shareStatus(ShareStatus var1);

        public Builder creationTime(String var1);

        public Builder modificationTime(String var1);
    }
}

