/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutResolverRulePolicyRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, PutResolverRulePolicyRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(PutResolverRulePolicyRequest.getter(PutResolverRulePolicyRequest::arn)).setter(PutResolverRulePolicyRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> RESOLVER_RULE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverRulePolicy").getter(PutResolverRulePolicyRequest.getter(PutResolverRulePolicyRequest::resolverRulePolicy)).setter(PutResolverRulePolicyRequest.setter(Builder::resolverRulePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRulePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, RESOLVER_RULE_POLICY_FIELD));
    private final String arn;
    private final String resolverRulePolicy;

    private PutResolverRulePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.resolverRulePolicy = builder.resolverRulePolicy;
    }

    public final String arn() {
        return this.arn;
    }

    public final String resolverRulePolicy() {
        return this.resolverRulePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverRulePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResolverRulePolicyRequest)) {
            return false;
        }
        PutResolverRulePolicyRequest other = (PutResolverRulePolicyRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.resolverRulePolicy(), other.resolverRulePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutResolverRulePolicyRequest").add("Arn", (Object)this.arn()).add("ResolverRulePolicy", (Object)this.resolverRulePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ResolverRulePolicy": {
                return Optional.ofNullable(clazz.cast(this.resolverRulePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResolverRulePolicyRequest, T> g) {
        return obj -> g.apply((PutResolverRulePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String resolverRulePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResolverRulePolicyRequest model) {
            super(model);
            this.arn(model.arn);
            this.resolverRulePolicy(model.resolverRulePolicy);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResolverRulePolicy() {
            return this.resolverRulePolicy;
        }

        public final void setResolverRulePolicy(String resolverRulePolicy) {
            this.resolverRulePolicy = resolverRulePolicy;
        }

        @Override
        public final Builder resolverRulePolicy(String resolverRulePolicy) {
            this.resolverRulePolicy = resolverRulePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResolverRulePolicyRequest build() {
            return new PutResolverRulePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutResolverRulePolicyRequest> {
        public Builder arn(String var1);

        public Builder resolverRulePolicy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

