/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigAssociationsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociation;

public class ListResolverQueryLogConfigAssociationsIterable
implements SdkIterable<ListResolverQueryLogConfigAssociationsResponse> {
    private final Route53ResolverClient client;
    private final ListResolverQueryLogConfigAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolverQueryLogConfigAssociationsIterable(Route53ResolverClient client, ListResolverQueryLogConfigAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResolverQueryLogConfigAssociationsResponseFetcher();
    }

    public Iterator<ListResolverQueryLogConfigAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations() {
        Function<ListResolverQueryLogConfigAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverQueryLogConfigAssociations() != null) {
                return response.resolverQueryLogConfigAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResolverQueryLogConfigAssociationsResponseFetcher
    implements SyncPageFetcher<ListResolverQueryLogConfigAssociationsResponse> {
        private ListResolverQueryLogConfigAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverQueryLogConfigAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolverQueryLogConfigAssociationsResponse nextPage(ListResolverQueryLogConfigAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverQueryLogConfigAssociationsIterable.this.client.listResolverQueryLogConfigAssociations(ListResolverQueryLogConfigAssociationsIterable.this.firstRequest);
            }
            return ListResolverQueryLogConfigAssociationsIterable.this.client.listResolverQueryLogConfigAssociations((ListResolverQueryLogConfigAssociationsRequest)((Object)ListResolverQueryLogConfigAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

