/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainListStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallDomainList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallDomainList> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(FirewallDomainList.getter(FirewallDomainList::id)).setter(FirewallDomainList.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(FirewallDomainList.getter(FirewallDomainList::arn)).setter(FirewallDomainList.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FirewallDomainList.getter(FirewallDomainList::name)).setter(FirewallDomainList.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> DOMAIN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DomainCount").getter(FirewallDomainList.getter(FirewallDomainList::domainCount)).setter(FirewallDomainList.setter(Builder::domainCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FirewallDomainList.getter(FirewallDomainList::statusAsString)).setter(FirewallDomainList.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(FirewallDomainList.getter(FirewallDomainList::statusMessage)).setter(FirewallDomainList.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> MANAGED_OWNER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedOwnerName").getter(FirewallDomainList.getter(FirewallDomainList::managedOwnerName)).setter(FirewallDomainList.setter(Builder::managedOwnerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedOwnerName").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(FirewallDomainList.getter(FirewallDomainList::creatorRequestId)).setter(FirewallDomainList.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(FirewallDomainList.getter(FirewallDomainList::creationTime)).setter(FirewallDomainList.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationTime").getter(FirewallDomainList.getter(FirewallDomainList::modificationTime)).setter(FirewallDomainList.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, DOMAIN_COUNT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, MANAGED_OWNER_NAME_FIELD, CREATOR_REQUEST_ID_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final Integer domainCount;
    private final String status;
    private final String statusMessage;
    private final String managedOwnerName;
    private final String creatorRequestId;
    private final String creationTime;
    private final String modificationTime;

    private FirewallDomainList(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.domainCount = builder.domainCount;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.managedOwnerName = builder.managedOwnerName;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Integer domainCount() {
        return this.domainCount;
    }

    public final FirewallDomainListStatus status() {
        return FirewallDomainListStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String managedOwnerName() {
        return this.managedOwnerName;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String modificationTime() {
        return this.modificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedOwnerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallDomainList)) {
            return false;
        }
        FirewallDomainList other = (FirewallDomainList)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.domainCount(), other.domainCount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.managedOwnerName(), other.managedOwnerName()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modificationTime(), other.modificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallDomainList").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("DomainCount", (Object)this.domainCount()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ManagedOwnerName", (Object)this.managedOwnerName()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("CreationTime", (Object)this.creationTime()).add("ModificationTime", (Object)this.modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DomainCount": {
                return Optional.ofNullable(clazz.cast(this.domainCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ManagedOwnerName": {
                return Optional.ofNullable(clazz.cast(this.managedOwnerName()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallDomainList, T> g) {
        return obj -> g.apply((FirewallDomainList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private Integer domainCount;
        private String status;
        private String statusMessage;
        private String managedOwnerName;
        private String creatorRequestId;
        private String creationTime;
        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallDomainList model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.domainCount(model.domainCount);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.managedOwnerName(model.managedOwnerName);
            this.creatorRequestId(model.creatorRequestId);
            this.creationTime(model.creationTime);
            this.modificationTime(model.modificationTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getDomainCount() {
            return this.domainCount;
        }

        public final void setDomainCount(Integer domainCount) {
            this.domainCount = domainCount;
        }

        @Override
        public final Builder domainCount(Integer domainCount) {
            this.domainCount = domainCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallDomainListStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getManagedOwnerName() {
            return this.managedOwnerName;
        }

        public final void setManagedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
        }

        @Override
        public final Builder managedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return this.modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public FirewallDomainList build() {
            return new FirewallDomainList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallDomainList> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder domainCount(Integer var1);

        public Builder status(String var1);

        public Builder status(FirewallDomainListStatus var1);

        public Builder statusMessage(String var1);

        public Builder managedOwnerName(String var1);

        public Builder creatorRequestId(String var1);

        public Builder creationTime(String var1);

        public Builder modificationTime(String var1);
    }
}

