/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint;
import software.amazon.awssdk.services.route53resolver.model.ResolverEndpointsCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResolverEndpointsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListResolverEndpointsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResolverEndpointsResponse.getter(ListResolverEndpointsResponse::nextToken)).setter(ListResolverEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResolverEndpointsResponse.getter(ListResolverEndpointsResponse::maxResults)).setter(ListResolverEndpointsResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<ResolverEndpoint>> RESOLVER_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResolverEndpoints").getter(ListResolverEndpointsResponse.getter(ListResolverEndpointsResponse::resolverEndpoints)).setter(ListResolverEndpointsResponse.setter(Builder::resolverEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolverEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOLVER_ENDPOINTS_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final List<ResolverEndpoint> resolverEndpoints;

    private ListResolverEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resolverEndpoints = builder.resolverEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasResolverEndpoints() {
        return this.resolverEndpoints != null && !(this.resolverEndpoints instanceof SdkAutoConstructList);
    }

    public final List<ResolverEndpoint> resolverEndpoints() {
        return this.resolverEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolverEndpoints() ? this.resolverEndpoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverEndpointsResponse)) {
            return false;
        }
        ListResolverEndpointsResponse other = (ListResolverEndpointsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasResolverEndpoints() == other.hasResolverEndpoints() && Objects.equals(this.resolverEndpoints(), other.resolverEndpoints());
    }

    public final String toString() {
        return ToString.builder((String)"ListResolverEndpointsResponse").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResolverEndpoints", this.hasResolverEndpoints() ? this.resolverEndpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ResolverEndpoints": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverEndpointsResponse, T> g) {
        return obj -> g.apply((ListResolverEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<ResolverEndpoint> resolverEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverEndpointsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resolverEndpoints(model.resolverEndpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final List<ResolverEndpoint.Builder> getResolverEndpoints() {
            List<ResolverEndpoint.Builder> result = ResolverEndpointsCopier.copyToBuilder(this.resolverEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resolverEndpoints(Collection<ResolverEndpoint> resolverEndpoints) {
            this.resolverEndpoints = ResolverEndpointsCopier.copy(resolverEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverEndpoints(ResolverEndpoint ... resolverEndpoints) {
            this.resolverEndpoints(Arrays.asList(resolverEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverEndpoints(Consumer<ResolverEndpoint.Builder> ... resolverEndpoints) {
            this.resolverEndpoints(Stream.of(resolverEndpoints).map(c -> (ResolverEndpoint)((ResolverEndpoint.Builder)ResolverEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolverEndpoints(Collection<ResolverEndpoint.BuilderImpl> resolverEndpoints) {
            this.resolverEndpoints = ResolverEndpointsCopier.copyFromBuilder(resolverEndpoints);
        }

        @Override
        public ListResolverEndpointsResponse build() {
            return new ListResolverEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResolverEndpointsResponse> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resolverEndpoints(Collection<ResolverEndpoint> var1);

        public Builder resolverEndpoints(ResolverEndpoint ... var1);

        public Builder resolverEndpoints(Consumer<ResolverEndpoint.Builder> ... var1);
    }
}

