/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadataListCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFirewallDomainListsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListFirewallDomainListsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFirewallDomainListsResponse.getter(ListFirewallDomainListsResponse::nextToken)).setter(ListFirewallDomainListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FirewallDomainListMetadata>> FIREWALL_DOMAIN_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FirewallDomainLists").getter(ListFirewallDomainListsResponse.getter(ListFirewallDomainListsResponse::firewallDomainLists)).setter(ListFirewallDomainListsResponse.setter(Builder::firewallDomainLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallDomainListMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FIREWALL_DOMAIN_LISTS_FIELD));
    private final String nextToken;
    private final List<FirewallDomainListMetadata> firewallDomainLists;

    private ListFirewallDomainListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallDomainLists = builder.firewallDomainLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFirewallDomainLists() {
        return this.firewallDomainLists != null && !(this.firewallDomainLists instanceof SdkAutoConstructList);
    }

    public final List<FirewallDomainListMetadata> firewallDomainLists() {
        return this.firewallDomainLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewallDomainLists() ? this.firewallDomainLists() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallDomainListsResponse)) {
            return false;
        }
        ListFirewallDomainListsResponse other = (ListFirewallDomainListsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFirewallDomainLists() == other.hasFirewallDomainLists() && Objects.equals(this.firewallDomainLists(), other.firewallDomainLists());
    }

    public final String toString() {
        return ToString.builder((String)"ListFirewallDomainListsResponse").add("NextToken", (Object)this.nextToken()).add("FirewallDomainLists", this.hasFirewallDomainLists() ? this.firewallDomainLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FirewallDomainLists": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainLists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallDomainListsResponse, T> g) {
        return obj -> g.apply((ListFirewallDomainListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FirewallDomainListMetadata> firewallDomainLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallDomainListsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.firewallDomainLists(model.firewallDomainLists);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<FirewallDomainListMetadata.Builder> getFirewallDomainLists() {
            List<FirewallDomainListMetadata.Builder> result = FirewallDomainListMetadataListCopier.copyToBuilder(this.firewallDomainLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder firewallDomainLists(Collection<FirewallDomainListMetadata> firewallDomainLists) {
            this.firewallDomainLists = FirewallDomainListMetadataListCopier.copy(firewallDomainLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallDomainLists(FirewallDomainListMetadata ... firewallDomainLists) {
            this.firewallDomainLists(Arrays.asList(firewallDomainLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallDomainLists(Consumer<FirewallDomainListMetadata.Builder> ... firewallDomainLists) {
            this.firewallDomainLists(Stream.of(firewallDomainLists).map(c -> (FirewallDomainListMetadata)((FirewallDomainListMetadata.Builder)FirewallDomainListMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFirewallDomainLists(Collection<FirewallDomainListMetadata.BuilderImpl> firewallDomainLists) {
            this.firewallDomainLists = FirewallDomainListMetadataListCopier.copyFromBuilder(firewallDomainLists);
        }

        @Override
        public ListFirewallDomainListsResponse build() {
            return new ListFirewallDomainListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFirewallDomainListsResponse> {
        public Builder nextToken(String var1);

        public Builder firewallDomainLists(Collection<FirewallDomainListMetadata> var1);

        public Builder firewallDomainLists(FirewallDomainListMetadata ... var1);

        public Builder firewallDomainLists(Consumer<FirewallDomainListMetadata.Builder> ... var1);
    }
}

