/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallRuleGroupMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallRuleGroupMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(FirewallRuleGroupMetadata.getter(FirewallRuleGroupMetadata::id)).setter(FirewallRuleGroupMetadata.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(FirewallRuleGroupMetadata.getter(FirewallRuleGroupMetadata::arn)).setter(FirewallRuleGroupMetadata.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FirewallRuleGroupMetadata.getter(FirewallRuleGroupMetadata::name)).setter(FirewallRuleGroupMetadata.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(FirewallRuleGroupMetadata.getter(FirewallRuleGroupMetadata::ownerId)).setter(FirewallRuleGroupMetadata.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(FirewallRuleGroupMetadata.getter(FirewallRuleGroupMetadata::creatorRequestId)).setter(FirewallRuleGroupMetadata.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareStatus").getter(FirewallRuleGroupMetadata.getter(FirewallRuleGroupMetadata::shareStatusAsString)).setter(FirewallRuleGroupMetadata.setter(Builder::shareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, OWNER_ID_FIELD, CREATOR_REQUEST_ID_FIELD, SHARE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String ownerId;
    private final String creatorRequestId;
    private final String shareStatus;

    private FirewallRuleGroupMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.creatorRequestId = builder.creatorRequestId;
        this.shareStatus = builder.shareStatus;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(this.shareStatus);
    }

    public final String shareStatusAsString() {
        return this.shareStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallRuleGroupMetadata)) {
            return false;
        }
        FirewallRuleGroupMetadata other = (FirewallRuleGroupMetadata)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.shareStatusAsString(), other.shareStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallRuleGroupMetadata").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("OwnerId", (Object)this.ownerId()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("ShareStatus", (Object)this.shareStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "ShareStatus": {
                return Optional.ofNullable(clazz.cast(this.shareStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallRuleGroupMetadata, T> g) {
        return obj -> g.apply((FirewallRuleGroupMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String ownerId;
        private String creatorRequestId;
        private String shareStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallRuleGroupMetadata model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.ownerId(model.ownerId);
            this.creatorRequestId(model.creatorRequestId);
            this.shareStatus(model.shareStatus);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getShareStatus() {
            return this.shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        public FirewallRuleGroupMetadata build() {
            return new FirewallRuleGroupMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallRuleGroupMetadata> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder ownerId(String var1);

        public Builder creatorRequestId(String var1);

        public Builder shareStatus(String var1);

        public Builder shareStatus(ShareStatus var1);
    }
}

