/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociation;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationsCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFirewallRuleGroupAssociationsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListFirewallRuleGroupAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFirewallRuleGroupAssociationsResponse.getter(ListFirewallRuleGroupAssociationsResponse::nextToken)).setter(ListFirewallRuleGroupAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FirewallRuleGroupAssociation>> FIREWALL_RULE_GROUP_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FirewallRuleGroupAssociations").getter(ListFirewallRuleGroupAssociationsResponse.getter(ListFirewallRuleGroupAssociationsResponse::firewallRuleGroupAssociations)).setter(ListFirewallRuleGroupAssociationsResponse.setter(Builder::firewallRuleGroupAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallRuleGroupAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FIREWALL_RULE_GROUP_ASSOCIATIONS_FIELD));
    private final String nextToken;
    private final List<FirewallRuleGroupAssociation> firewallRuleGroupAssociations;

    private ListFirewallRuleGroupAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallRuleGroupAssociations = builder.firewallRuleGroupAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFirewallRuleGroupAssociations() {
        return this.firewallRuleGroupAssociations != null && !(this.firewallRuleGroupAssociations instanceof SdkAutoConstructList);
    }

    public final List<FirewallRuleGroupAssociation> firewallRuleGroupAssociations() {
        return this.firewallRuleGroupAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewallRuleGroupAssociations() ? this.firewallRuleGroupAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRuleGroupAssociationsResponse)) {
            return false;
        }
        ListFirewallRuleGroupAssociationsResponse other = (ListFirewallRuleGroupAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFirewallRuleGroupAssociations() == other.hasFirewallRuleGroupAssociations() && Objects.equals(this.firewallRuleGroupAssociations(), other.firewallRuleGroupAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListFirewallRuleGroupAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("FirewallRuleGroupAssociations", this.hasFirewallRuleGroupAssociations() ? this.firewallRuleGroupAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FirewallRuleGroupAssociations": {
                return Optional.ofNullable(clazz.cast(this.firewallRuleGroupAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRuleGroupAssociationsResponse, T> g) {
        return obj -> g.apply((ListFirewallRuleGroupAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FirewallRuleGroupAssociation> firewallRuleGroupAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRuleGroupAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.firewallRuleGroupAssociations(model.firewallRuleGroupAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<FirewallRuleGroupAssociation.Builder> getFirewallRuleGroupAssociations() {
            if (this.firewallRuleGroupAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.firewallRuleGroupAssociations != null ? (Collection)this.firewallRuleGroupAssociations.stream().map(FirewallRuleGroupAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder firewallRuleGroupAssociations(Collection<FirewallRuleGroupAssociation> firewallRuleGroupAssociations) {
            this.firewallRuleGroupAssociations = FirewallRuleGroupAssociationsCopier.copy(firewallRuleGroupAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRuleGroupAssociations(FirewallRuleGroupAssociation ... firewallRuleGroupAssociations) {
            this.firewallRuleGroupAssociations(Arrays.asList(firewallRuleGroupAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRuleGroupAssociations(Consumer<FirewallRuleGroupAssociation.Builder> ... firewallRuleGroupAssociations) {
            this.firewallRuleGroupAssociations(Stream.of(firewallRuleGroupAssociations).map(c -> (FirewallRuleGroupAssociation)((FirewallRuleGroupAssociation.Builder)FirewallRuleGroupAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFirewallRuleGroupAssociations(Collection<FirewallRuleGroupAssociation.BuilderImpl> firewallRuleGroupAssociations) {
            this.firewallRuleGroupAssociations = FirewallRuleGroupAssociationsCopier.copyFromBuilder(firewallRuleGroupAssociations);
        }

        @Override
        public ListFirewallRuleGroupAssociationsResponse build() {
            return new ListFirewallRuleGroupAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFirewallRuleGroupAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder firewallRuleGroupAssociations(Collection<FirewallRuleGroupAssociation> var1);

        public Builder firewallRuleGroupAssociations(FirewallRuleGroupAssociation ... var1);

        public Builder firewallRuleGroupAssociations(Consumer<FirewallRuleGroupAssociation.Builder> ... var1);
    }
}

