/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.FirewallConfig;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse;

public class ListFirewallConfigsPublisher
implements SdkPublisher<ListFirewallConfigsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListFirewallConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFirewallConfigsPublisher(Route53ResolverAsyncClient client, ListFirewallConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFirewallConfigsPublisher(Route53ResolverAsyncClient client, ListFirewallConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFirewallConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFirewallConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FirewallConfig> firewallConfigs() {
        Function<ListFirewallConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallConfigs() != null) {
                return response.firewallConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFirewallConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFirewallConfigsResponseFetcher
    implements AsyncPageFetcher<ListFirewallConfigsResponse> {
        private ListFirewallConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFirewallConfigsResponse> nextPage(ListFirewallConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallConfigsPublisher.this.client.listFirewallConfigs(ListFirewallConfigsPublisher.this.firstRequest);
            }
            return ListFirewallConfigsPublisher.this.client.listFirewallConfigs((ListFirewallConfigsRequest)((Object)ListFirewallConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

