/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolverRuleAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolverRuleAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResolverRuleAssociation.getter(ResolverRuleAssociation::id)).setter(ResolverRuleAssociation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> RESOLVER_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolverRuleId").getter(ResolverRuleAssociation.getter(ResolverRuleAssociation::resolverRuleId)).setter(ResolverRuleAssociation.setter(Builder::resolverRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResolverRuleAssociation.getter(ResolverRuleAssociation::name)).setter(ResolverRuleAssociation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCId").getter(ResolverRuleAssociation.getter(ResolverRuleAssociation::vpcId)).setter(ResolverRuleAssociation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResolverRuleAssociation.getter(ResolverRuleAssociation::statusAsString)).setter(ResolverRuleAssociation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ResolverRuleAssociation.getter(ResolverRuleAssociation::statusMessage)).setter(ResolverRuleAssociation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOLVER_RULE_ID_FIELD, NAME_FIELD, VPC_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String resolverRuleId;
    private final String name;
    private final String vpcId;
    private final String status;
    private final String statusMessage;

    private ResolverRuleAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.resolverRuleId = builder.resolverRuleId;
        this.name = builder.name;
        this.vpcId = builder.vpcId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String id() {
        return this.id;
    }

    public final String resolverRuleId() {
        return this.resolverRuleId;
    }

    public final String name() {
        return this.name;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final ResolverRuleAssociationStatus status() {
        return ResolverRuleAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverRuleAssociation)) {
            return false;
        }
        ResolverRuleAssociation other = (ResolverRuleAssociation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.resolverRuleId(), other.resolverRuleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ResolverRuleAssociation").add("Id", (Object)this.id()).add("ResolverRuleId", (Object)this.resolverRuleId()).add("Name", (Object)this.name()).add("VPCId", (Object)this.vpcId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ResolverRuleId": {
                return Optional.ofNullable(clazz.cast(this.resolverRuleId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VPCId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolverRuleAssociation, T> g) {
        return obj -> g.apply((ResolverRuleAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String resolverRuleId;
        private String name;
        private String vpcId;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverRuleAssociation model) {
            this.id(model.id);
            this.resolverRuleId(model.resolverRuleId);
            this.name(model.name);
            this.vpcId(model.vpcId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResolverRuleId() {
            return this.resolverRuleId;
        }

        @Override
        public final Builder resolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
            return this;
        }

        public final void setResolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResolverRuleAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ResolverRuleAssociation build() {
            return new ResolverRuleAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolverRuleAssociation> {
        public Builder id(String var1);

        public Builder resolverRuleId(String var1);

        public Builder name(String var1);

        public Builder vpcId(String var1);

        public Builder status(String var1);

        public Builder status(ResolverRuleAssociationStatus var1);

        public Builder statusMessage(String var1);
    }
}

