/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.IpAddressRequest;
import software.amazon.awssdk.services.route53resolver.model.IpAddressesRequestCopier;
import software.amazon.awssdk.services.route53resolver.model.ResolverEndpointDirection;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.route53resolver.model.Tag;
import software.amazon.awssdk.services.route53resolver.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResolverEndpointRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, CreateResolverEndpointRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateResolverEndpointRequest.getter(CreateResolverEndpointRequest::creatorRequestId)).setter(CreateResolverEndpointRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateResolverEndpointRequest.getter(CreateResolverEndpointRequest::name)).setter(CreateResolverEndpointRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateResolverEndpointRequest.getter(CreateResolverEndpointRequest::securityGroupIds)).setter(CreateResolverEndpointRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(CreateResolverEndpointRequest.getter(CreateResolverEndpointRequest::directionAsString)).setter(CreateResolverEndpointRequest.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<List<IpAddressRequest>> IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpAddresses").getter(CreateResolverEndpointRequest.getter(CreateResolverEndpointRequest::ipAddresses)).setter(CreateResolverEndpointRequest.setter(Builder::ipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpAddressRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateResolverEndpointRequest.getter(CreateResolverEndpointRequest::tags)).setter(CreateResolverEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD, NAME_FIELD, SECURITY_GROUP_IDS_FIELD, DIRECTION_FIELD, IP_ADDRESSES_FIELD, TAGS_FIELD));
    private final String creatorRequestId;
    private final String name;
    private final List<String> securityGroupIds;
    private final String direction;
    private final List<IpAddressRequest> ipAddresses;
    private final List<Tag> tags;

    private CreateResolverEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.name = builder.name;
        this.securityGroupIds = builder.securityGroupIds;
        this.direction = builder.direction;
        this.ipAddresses = builder.ipAddresses;
        this.tags = builder.tags;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public String name() {
        return this.name;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public ResolverEndpointDirection direction() {
        return ResolverEndpointDirection.fromValue(this.direction);
    }

    public String directionAsString() {
        return this.direction;
    }

    public boolean hasIpAddresses() {
        return this.ipAddresses != null && !(this.ipAddresses instanceof SdkAutoConstructList);
    }

    public List<IpAddressRequest> ipAddresses() {
        return this.ipAddresses;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResolverEndpointRequest)) {
            return false;
        }
        CreateResolverEndpointRequest other = (CreateResolverEndpointRequest)((Object)obj);
        return Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.ipAddresses(), other.ipAddresses()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateResolverEndpointRequest").add("CreatorRequestId", (Object)this.creatorRequestId()).add("Name", (Object)this.name()).add("SecurityGroupIds", this.securityGroupIds()).add("Direction", (Object)this.directionAsString()).add("IpAddresses", this.ipAddresses()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "IpAddresses": {
                return Optional.ofNullable(clazz.cast(this.ipAddresses()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResolverEndpointRequest, T> g) {
        return obj -> g.apply((CreateResolverEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String creatorRequestId;
        private String name;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String direction;
        private List<IpAddressRequest> ipAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResolverEndpointRequest model) {
            super(model);
            this.creatorRequestId(model.creatorRequestId);
            this.name(model.name);
            this.securityGroupIds(model.securityGroupIds);
            this.direction(model.direction);
            this.ipAddresses(model.ipAddresses);
            this.tags(model.tags);
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final String getDirection() {
            return this.direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(ResolverEndpointDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        public final Collection<IpAddressRequest.Builder> getIpAddresses() {
            return this.ipAddresses != null ? (Collection)this.ipAddresses.stream().map(IpAddressRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipAddresses(Collection<IpAddressRequest> ipAddresses) {
            this.ipAddresses = IpAddressesRequestCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(IpAddressRequest ... ipAddresses) {
            this.ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(Consumer<IpAddressRequest.Builder> ... ipAddresses) {
            this.ipAddresses(Stream.of(ipAddresses).map(c -> (IpAddressRequest)((IpAddressRequest.Builder)IpAddressRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpAddresses(Collection<IpAddressRequest.BuilderImpl> ipAddresses) {
            this.ipAddresses = IpAddressesRequestCopier.copyFromBuilder(ipAddresses);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResolverEndpointRequest build() {
            return new CreateResolverEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResolverEndpointRequest> {
        public Builder creatorRequestId(String var1);

        public Builder name(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder direction(String var1);

        public Builder direction(ResolverEndpointDirection var1);

        public Builder ipAddresses(Collection<IpAddressRequest> var1);

        public Builder ipAddresses(IpAddressRequest ... var1);

        public Builder ipAddresses(Consumer<IpAddressRequest.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

