/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse;

public class ListResolverRuleAssociationsIterable
implements SdkIterable<ListResolverRuleAssociationsResponse> {
    private final Route53ResolverClient client;
    private final ListResolverRuleAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolverRuleAssociationsIterable(Route53ResolverClient client, ListResolverRuleAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResolverRuleAssociationsResponseFetcher();
    }

    public Iterator<ListResolverRuleAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListResolverRuleAssociationsIterable resume(ListResolverRuleAssociationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResolverRuleAssociationsIterable(this.client, (ListResolverRuleAssociationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListResolverRuleAssociationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListResolverRuleAssociationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListResolverRuleAssociationsResponseFetcher
    implements SyncPageFetcher<ListResolverRuleAssociationsResponse> {
        private ListResolverRuleAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverRuleAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolverRuleAssociationsResponse nextPage(ListResolverRuleAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverRuleAssociationsIterable.this.client.listResolverRuleAssociations(ListResolverRuleAssociationsIterable.this.firstRequest);
            }
            return ListResolverRuleAssociationsIterable.this.client.listResolverRuleAssociations((ListResolverRuleAssociationsRequest)((Object)ListResolverRuleAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

