/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse;

public class ListResolverEndpointsIterable
implements SdkIterable<ListResolverEndpointsResponse> {
    private final Route53ResolverClient client;
    private final ListResolverEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolverEndpointsIterable(Route53ResolverClient client, ListResolverEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResolverEndpointsResponseFetcher();
    }

    public Iterator<ListResolverEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListResolverEndpointsIterable resume(ListResolverEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResolverEndpointsIterable(this.client, (ListResolverEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListResolverEndpointsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListResolverEndpointsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListResolverEndpointsResponseFetcher
    implements SyncPageFetcher<ListResolverEndpointsResponse> {
        private ListResolverEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolverEndpointsResponse nextPage(ListResolverEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverEndpointsIterable.this.client.listResolverEndpoints(ListResolverEndpointsIterable.this.firstRequest);
            }
            return ListResolverEndpointsIterable.this.client.listResolverEndpoints((ListResolverEndpointsRequest)((Object)ListResolverEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

