/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceResult;

public class GetReadinessCheckStatusIterable
implements SdkIterable<GetReadinessCheckStatusResponse> {
    private final Route53RecoveryReadinessClient client;
    private final GetReadinessCheckStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetReadinessCheckStatusIterable(Route53RecoveryReadinessClient client, GetReadinessCheckStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetReadinessCheckStatusResponseFetcher();
    }

    public Iterator<GetReadinessCheckStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceResult> resources() {
        Function<GetReadinessCheckStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetReadinessCheckStatusResponseFetcher
    implements SyncPageFetcher<GetReadinessCheckStatusResponse> {
        private GetReadinessCheckStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetReadinessCheckStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetReadinessCheckStatusResponse nextPage(GetReadinessCheckStatusResponse previousPage) {
            if (previousPage == null) {
                return GetReadinessCheckStatusIterable.this.client.getReadinessCheckStatus(GetReadinessCheckStatusIterable.this.firstRequest);
            }
            return GetReadinessCheckStatusIterable.this.client.getReadinessCheckStatus((GetReadinessCheckStatusRequest)((Object)GetReadinessCheckStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

