/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessAsyncClient;
import software.amazon.awssdk.services.route53recoveryreadiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse;

public class ListCrossAccountAuthorizationsPublisher
implements SdkPublisher<ListCrossAccountAuthorizationsResponse> {
    private final Route53RecoveryReadinessAsyncClient client;
    private final ListCrossAccountAuthorizationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCrossAccountAuthorizationsPublisher(Route53RecoveryReadinessAsyncClient client, ListCrossAccountAuthorizationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCrossAccountAuthorizationsPublisher(Route53RecoveryReadinessAsyncClient client, ListCrossAccountAuthorizationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCrossAccountAuthorizationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCrossAccountAuthorizationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> crossAccountAuthorizations() {
        Function<ListCrossAccountAuthorizationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.crossAccountAuthorizations() != null) {
                return response.crossAccountAuthorizations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCrossAccountAuthorizationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCrossAccountAuthorizationsResponseFetcher
    implements AsyncPageFetcher<ListCrossAccountAuthorizationsResponse> {
        private ListCrossAccountAuthorizationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCrossAccountAuthorizationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCrossAccountAuthorizationsResponse> nextPage(ListCrossAccountAuthorizationsResponse previousPage) {
            if (previousPage == null) {
                return ListCrossAccountAuthorizationsPublisher.this.client.listCrossAccountAuthorizations(ListCrossAccountAuthorizationsPublisher.this.firstRequest);
            }
            return ListCrossAccountAuthorizationsPublisher.this.client.listCrossAccountAuthorizations((ListCrossAccountAuthorizationsRequest)((Object)ListCrossAccountAuthorizationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

