/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Readiness {
    READY("READY"),
    NOT_READY("NOT_READY"),
    UNKNOWN("UNKNOWN"),
    NOT_AUTHORIZED("NOT_AUTHORIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Readiness> VALUE_MAP;
    private final String value;

    private Readiness(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Readiness fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Readiness> knownValues() {
        EnumSet<Readiness> knownValues = EnumSet.allOf(Readiness.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Readiness.class, Readiness::toString);
    }
}

