/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceSetsResponse extends Route53RecoveryReadinessResponse implements
        ToCopyableBuilder<ListResourceSetsResponse.Builder, ListResourceSetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ResourceSetOutput>> RESOURCE_SETS_FIELD = SdkField
            .<List<ResourceSetOutput>> builder(MarshallingType.LIST)
            .memberName("ResourceSets")
            .getter(getter(ListResourceSetsResponse::resourceSets))
            .setter(setter(Builder::resourceSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceSetOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceSetOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESOURCE_SETS_FIELD));

    private final String nextToken;

    private final List<ResourceSetOutput> resourceSets;

    private ListResourceSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourceSets = builder.resourceSets;
    }

    /**
     * <p>
     * The token that identifies which batch of results you want to see.
     * </p>
     * 
     * @return The token that identifies which batch of results you want to see.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceSets() {
        return resourceSets != null && !(resourceSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource sets associated with the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceSets} method.
     * </p>
     * 
     * @return A list of resource sets associated with the account.
     */
    public final List<ResourceSetOutput> resourceSets() {
        return resourceSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceSets() ? resourceSets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceSetsResponse)) {
            return false;
        }
        ListResourceSetsResponse other = (ListResourceSetsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasResourceSets() == other.hasResourceSets()
                && Objects.equals(resourceSets(), other.resourceSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceSetsResponse").add("NextToken", nextToken())
                .add("ResourceSets", hasResourceSets() ? resourceSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResourceSets":
            return Optional.ofNullable(clazz.cast(resourceSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceSetsResponse, T> g) {
        return obj -> g.apply((ListResourceSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryReadinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceSetsResponse> {
        /**
         * <p>
         * The token that identifies which batch of results you want to see.
         * </p>
         * 
         * @param nextToken
         *        The token that identifies which batch of results you want to see.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of resource sets associated with the account.
         * </p>
         * 
         * @param resourceSets
         *        A list of resource sets associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSets(Collection<ResourceSetOutput> resourceSets);

        /**
         * <p>
         * A list of resource sets associated with the account.
         * </p>
         * 
         * @param resourceSets
         *        A list of resource sets associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSets(ResourceSetOutput... resourceSets);

        /**
         * <p>
         * A list of resource sets associated with the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceSetOutput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceSetOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceSetOutput.Builder#build()} is
         * called immediately and its result is passed to {@link #resourceSets(List<ResourceSetOutput>)}.
         * 
         * @param resourceSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceSetOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSets(java.util.Collection<ResourceSetOutput>)
         */
        Builder resourceSets(Consumer<ResourceSetOutput.Builder>... resourceSets);
    }

    static final class BuilderImpl extends Route53RecoveryReadinessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ResourceSetOutput> resourceSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceSetsResponse model) {
            super(model);
            nextToken(model.nextToken);
            resourceSets(model.resourceSets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourceSetOutput.Builder> getResourceSets() {
            List<ResourceSetOutput.Builder> result = ___listOfResourceSetOutputCopier.copyToBuilder(this.resourceSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSets(Collection<ResourceSetOutput.BuilderImpl> resourceSets) {
            this.resourceSets = ___listOfResourceSetOutputCopier.copyFromBuilder(resourceSets);
        }

        @Override
        public final Builder resourceSets(Collection<ResourceSetOutput> resourceSets) {
            this.resourceSets = ___listOfResourceSetOutputCopier.copy(resourceSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSets(ResourceSetOutput... resourceSets) {
            resourceSets(Arrays.asList(resourceSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSets(Consumer<ResourceSetOutput.Builder>... resourceSets) {
            resourceSets(Stream.of(resourceSets).map(c -> ResourceSetOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResourceSetsResponse build() {
            return new ListResourceSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
