/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.AccessDeniedException;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ConflictException;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateCellRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateCellResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateCrossAccountAuthorizationRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateCrossAccountAuthorizationResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateReadinessCheckRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateReadinessCheckResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateRecoveryGroupRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateRecoveryGroupResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateResourceSetRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CreateResourceSetResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteCellRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteCellResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteCrossAccountAuthorizationRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteCrossAccountAuthorizationResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteReadinessCheckRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteReadinessCheckResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteRecoveryGroupRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteRecoveryGroupResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteResourceSetRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.DeleteResourceSetResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetArchitectureRecommendationsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetArchitectureRecommendationsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellReadinessSummaryResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetCellResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResourceStatusResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetReadinessCheckStatusResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetResourceSetRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetResourceSetResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.InternalServerException;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCrossAccountAuthorizationsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRulesResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceNotFoundException;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessException;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagResourceRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagResourceResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ThrottlingException;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateCellRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateCellResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateReadinessCheckRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateReadinessCheckResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateRecoveryGroupRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateRecoveryGroupResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateResourceSetRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.UpdateResourceSetResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ValidationException;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetCellReadinessSummaryIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckResourceStatusIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetReadinessCheckStatusIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.GetRecoveryGroupReadinessSummaryIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCellsIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListCrossAccountAuthorizationsIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListReadinessChecksIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRecoveryGroupsIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListResourceSetsIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.paginators.ListRulesIterable;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.CreateCellRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.CreateCrossAccountAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.CreateReadinessCheckRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.CreateRecoveryGroupRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.CreateResourceSetRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.DeleteCellRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.DeleteCrossAccountAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.DeleteReadinessCheckRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.DeleteRecoveryGroupRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.DeleteResourceSetRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetArchitectureRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetCellReadinessSummaryRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetCellRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetReadinessCheckRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetReadinessCheckResourceStatusRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetReadinessCheckStatusRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetRecoveryGroupReadinessSummaryRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetRecoveryGroupRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.GetResourceSetRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.ListCellsRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.ListCrossAccountAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.ListReadinessChecksRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.ListRecoveryGroupsRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.ListResourceSetsRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.ListRulesRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.ListTagsForResourcesRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.UpdateCellRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.UpdateReadinessCheckRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.UpdateRecoveryGroupRequestMarshaller;
import software.amazon.awssdk.services.route53recoveryreadiness.transform.UpdateResourceSetRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRoute53RecoveryReadinessClient
implements Route53RecoveryReadinessClient {
    private static final Logger log = Logger.loggerFor(DefaultRoute53RecoveryReadinessClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53RecoveryReadinessClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "route53-recovery-readiness";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCellResponse createCell(CreateCellRequest createCellRequest) throws ThrottlingException, ValidationException, InternalServerException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCellResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, createCellRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCell");
            CreateCellResponse createCellResponse = (CreateCellResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCell").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCellRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCellRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCellResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$createCell$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCrossAccountAuthorizationResponse createCrossAccountAuthorization(CreateCrossAccountAuthorizationRequest createCrossAccountAuthorizationRequest) throws ThrottlingException, ValidationException, InternalServerException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCrossAccountAuthorizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, createCrossAccountAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCrossAccountAuthorization");
            CreateCrossAccountAuthorizationResponse createCrossAccountAuthorizationResponse = (CreateCrossAccountAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCrossAccountAuthorization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCrossAccountAuthorizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCrossAccountAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCrossAccountAuthorizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$createCrossAccountAuthorization$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReadinessCheckResponse createReadinessCheck(CreateReadinessCheckRequest createReadinessCheckRequest) throws ThrottlingException, ValidationException, InternalServerException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReadinessCheckResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, createReadinessCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReadinessCheck");
            CreateReadinessCheckResponse createReadinessCheckResponse = (CreateReadinessCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReadinessCheck").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReadinessCheckRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReadinessCheckRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReadinessCheckResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$createReadinessCheck$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRecoveryGroupResponse createRecoveryGroup(CreateRecoveryGroupRequest createRecoveryGroupRequest) throws ThrottlingException, ValidationException, InternalServerException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRecoveryGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, createRecoveryGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRecoveryGroup");
            CreateRecoveryGroupResponse createRecoveryGroupResponse = (CreateRecoveryGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRecoveryGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRecoveryGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRecoveryGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRecoveryGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$createRecoveryGroup$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceSetResponse createResourceSet(CreateResourceSetRequest createResourceSetRequest) throws ThrottlingException, ValidationException, InternalServerException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, createResourceSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResourceSet");
            CreateResourceSetResponse createResourceSetResponse = (CreateResourceSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResourceSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createResourceSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateResourceSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResourceSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$createResourceSet$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCellResponse deleteCell(DeleteCellRequest deleteCellRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCellResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, deleteCellRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCell");
            DeleteCellResponse deleteCellResponse = (DeleteCellResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCell").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCellRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCellRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCellResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$deleteCell$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCrossAccountAuthorizationResponse deleteCrossAccountAuthorization(DeleteCrossAccountAuthorizationRequest deleteCrossAccountAuthorizationRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCrossAccountAuthorizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, deleteCrossAccountAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCrossAccountAuthorization");
            DeleteCrossAccountAuthorizationResponse deleteCrossAccountAuthorizationResponse = (DeleteCrossAccountAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCrossAccountAuthorization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCrossAccountAuthorizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCrossAccountAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCrossAccountAuthorizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$deleteCrossAccountAuthorization$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReadinessCheckResponse deleteReadinessCheck(DeleteReadinessCheckRequest deleteReadinessCheckRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReadinessCheckResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, deleteReadinessCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReadinessCheck");
            DeleteReadinessCheckResponse deleteReadinessCheckResponse = (DeleteReadinessCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReadinessCheck").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReadinessCheckRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReadinessCheckRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReadinessCheckResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$deleteReadinessCheck$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRecoveryGroupResponse deleteRecoveryGroup(DeleteRecoveryGroupRequest deleteRecoveryGroupRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRecoveryGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, deleteRecoveryGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRecoveryGroup");
            DeleteRecoveryGroupResponse deleteRecoveryGroupResponse = (DeleteRecoveryGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRecoveryGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRecoveryGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRecoveryGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRecoveryGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$deleteRecoveryGroup$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourceSetResponse deleteResourceSet(DeleteResourceSetRequest deleteResourceSetRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, deleteResourceSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceSet");
            DeleteResourceSetResponse deleteResourceSetResponse = (DeleteResourceSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourceSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourceSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourceSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$deleteResourceSet$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetArchitectureRecommendationsResponse getArchitectureRecommendations(GetArchitectureRecommendationsRequest getArchitectureRecommendationsRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetArchitectureRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getArchitectureRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetArchitectureRecommendations");
            GetArchitectureRecommendationsResponse getArchitectureRecommendationsResponse = (GetArchitectureRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetArchitectureRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getArchitectureRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetArchitectureRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getArchitectureRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getArchitectureRecommendations$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCellResponse getCell(GetCellRequest getCellRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCellResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getCellRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCell");
            GetCellResponse getCellResponse = (GetCellResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCell").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCellRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCellRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCellResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getCell$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCellReadinessSummaryResponse getCellReadinessSummary(GetCellReadinessSummaryRequest getCellReadinessSummaryRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCellReadinessSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getCellReadinessSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCellReadinessSummary");
            GetCellReadinessSummaryResponse getCellReadinessSummaryResponse = (GetCellReadinessSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCellReadinessSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCellReadinessSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCellReadinessSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCellReadinessSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getCellReadinessSummary$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetCellReadinessSummaryIterable getCellReadinessSummaryPaginator(GetCellReadinessSummaryRequest getCellReadinessSummaryRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new GetCellReadinessSummaryIterable(this, this.applyPaginatorUserAgent(getCellReadinessSummaryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReadinessCheckResponse getReadinessCheck(GetReadinessCheckRequest getReadinessCheckRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReadinessCheckResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getReadinessCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReadinessCheck");
            GetReadinessCheckResponse getReadinessCheckResponse = (GetReadinessCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReadinessCheck").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReadinessCheckRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReadinessCheckRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReadinessCheckResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getReadinessCheck$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReadinessCheckResourceStatusResponse getReadinessCheckResourceStatus(GetReadinessCheckResourceStatusRequest getReadinessCheckResourceStatusRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReadinessCheckResourceStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getReadinessCheckResourceStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReadinessCheckResourceStatus");
            GetReadinessCheckResourceStatusResponse getReadinessCheckResourceStatusResponse = (GetReadinessCheckResourceStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReadinessCheckResourceStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReadinessCheckResourceStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReadinessCheckResourceStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReadinessCheckResourceStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getReadinessCheckResourceStatus$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetReadinessCheckResourceStatusIterable getReadinessCheckResourceStatusPaginator(GetReadinessCheckResourceStatusRequest getReadinessCheckResourceStatusRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new GetReadinessCheckResourceStatusIterable(this, this.applyPaginatorUserAgent(getReadinessCheckResourceStatusRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReadinessCheckStatusResponse getReadinessCheckStatus(GetReadinessCheckStatusRequest getReadinessCheckStatusRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReadinessCheckStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getReadinessCheckStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReadinessCheckStatus");
            GetReadinessCheckStatusResponse getReadinessCheckStatusResponse = (GetReadinessCheckStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReadinessCheckStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReadinessCheckStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReadinessCheckStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReadinessCheckStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getReadinessCheckStatus$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetReadinessCheckStatusIterable getReadinessCheckStatusPaginator(GetReadinessCheckStatusRequest getReadinessCheckStatusRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new GetReadinessCheckStatusIterable(this, this.applyPaginatorUserAgent(getReadinessCheckStatusRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecoveryGroupResponse getRecoveryGroup(GetRecoveryGroupRequest getRecoveryGroupRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecoveryGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getRecoveryGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecoveryGroup");
            GetRecoveryGroupResponse getRecoveryGroupResponse = (GetRecoveryGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecoveryGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecoveryGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecoveryGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecoveryGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getRecoveryGroup$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecoveryGroupReadinessSummaryResponse getRecoveryGroupReadinessSummary(GetRecoveryGroupReadinessSummaryRequest getRecoveryGroupReadinessSummaryRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecoveryGroupReadinessSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getRecoveryGroupReadinessSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecoveryGroupReadinessSummary");
            GetRecoveryGroupReadinessSummaryResponse getRecoveryGroupReadinessSummaryResponse = (GetRecoveryGroupReadinessSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecoveryGroupReadinessSummary").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecoveryGroupReadinessSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecoveryGroupReadinessSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecoveryGroupReadinessSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getRecoveryGroupReadinessSummary$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetRecoveryGroupReadinessSummaryIterable getRecoveryGroupReadinessSummaryPaginator(GetRecoveryGroupReadinessSummaryRequest getRecoveryGroupReadinessSummaryRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new GetRecoveryGroupReadinessSummaryIterable(this, this.applyPaginatorUserAgent(getRecoveryGroupReadinessSummaryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceSetResponse getResourceSet(GetResourceSetRequest getResourceSetRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, getResourceSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceSet");
            GetResourceSetResponse getResourceSetResponse = (GetResourceSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$getResourceSet$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCellsResponse listCells(ListCellsRequest listCellsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCellsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, listCellsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCells");
            ListCellsResponse listCellsResponse = (ListCellsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCells").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCellsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCellsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCellsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$listCells$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCellsIterable listCellsPaginator(ListCellsRequest listCellsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new ListCellsIterable(this, this.applyPaginatorUserAgent(listCellsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCrossAccountAuthorizationsResponse listCrossAccountAuthorizations(ListCrossAccountAuthorizationsRequest listCrossAccountAuthorizationsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCrossAccountAuthorizationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, listCrossAccountAuthorizationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCrossAccountAuthorizations");
            ListCrossAccountAuthorizationsResponse listCrossAccountAuthorizationsResponse = (ListCrossAccountAuthorizationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCrossAccountAuthorizations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCrossAccountAuthorizationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCrossAccountAuthorizationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCrossAccountAuthorizationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$listCrossAccountAuthorizations$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCrossAccountAuthorizationsIterable listCrossAccountAuthorizationsPaginator(ListCrossAccountAuthorizationsRequest listCrossAccountAuthorizationsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new ListCrossAccountAuthorizationsIterable(this, this.applyPaginatorUserAgent(listCrossAccountAuthorizationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReadinessChecksResponse listReadinessChecks(ListReadinessChecksRequest listReadinessChecksRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReadinessChecksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, listReadinessChecksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReadinessChecks");
            ListReadinessChecksResponse listReadinessChecksResponse = (ListReadinessChecksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReadinessChecks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReadinessChecksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReadinessChecksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReadinessChecksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$listReadinessChecks$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReadinessChecksIterable listReadinessChecksPaginator(ListReadinessChecksRequest listReadinessChecksRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new ListReadinessChecksIterable(this, this.applyPaginatorUserAgent(listReadinessChecksRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecoveryGroupsResponse listRecoveryGroups(ListRecoveryGroupsRequest listRecoveryGroupsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecoveryGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, listRecoveryGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecoveryGroups");
            ListRecoveryGroupsResponse listRecoveryGroupsResponse = (ListRecoveryGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecoveryGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecoveryGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecoveryGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecoveryGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$listRecoveryGroups$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRecoveryGroupsIterable listRecoveryGroupsPaginator(ListRecoveryGroupsRequest listRecoveryGroupsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new ListRecoveryGroupsIterable(this, this.applyPaginatorUserAgent(listRecoveryGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceSetsResponse listResourceSets(ListResourceSetsRequest listResourceSetsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, listResourceSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceSets");
            ListResourceSetsResponse listResourceSetsResponse = (ListResourceSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$listResourceSets$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListResourceSetsIterable listResourceSetsPaginator(ListResourceSetsRequest listResourceSetsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new ListResourceSetsIterable(this, this.applyPaginatorUserAgent(listResourceSetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, listRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRules");
            ListRulesResponse listRulesResponse = (ListRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$listRules$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRulesIterable listRulesPaginator(ListRulesRequest listRulesRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        return new ListRulesIterable(this, this.applyPaginatorUserAgent(listRulesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourcesResponse listTagsForResources(ListTagsForResourcesRequest listTagsForResourcesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResources");
            ListTagsForResourcesResponse listTagsForResourcesResponse = (ListTagsForResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$listTagsForResources$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$tagResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$untagResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCellResponse updateCell(UpdateCellRequest updateCellRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCellResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, updateCellRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCell");
            UpdateCellResponse updateCellResponse = (UpdateCellResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCell").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCellRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCellRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCellResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$updateCell$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReadinessCheckResponse updateReadinessCheck(UpdateReadinessCheckRequest updateReadinessCheckRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReadinessCheckResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, updateReadinessCheckRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReadinessCheck");
            UpdateReadinessCheckResponse updateReadinessCheckResponse = (UpdateReadinessCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReadinessCheck").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateReadinessCheckRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReadinessCheckRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReadinessCheckResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$updateReadinessCheck$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRecoveryGroupResponse updateRecoveryGroup(UpdateRecoveryGroupRequest updateRecoveryGroupRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRecoveryGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, updateRecoveryGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRecoveryGroup");
            UpdateRecoveryGroupResponse updateRecoveryGroupResponse = (UpdateRecoveryGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRecoveryGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRecoveryGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRecoveryGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRecoveryGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$updateRecoveryGroup$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceSetResponse updateResourceSet(UpdateResourceSetRequest updateResourceSetRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, Route53RecoveryReadinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRoute53RecoveryReadinessClient.resolveMetricPublishers(this.clientConfiguration, updateResourceSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route53 Recovery Readiness");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResourceSet");
            UpdateResourceSetResponse updateResourceSetResponse = (UpdateResourceSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResourceSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResourceSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResourceSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResourceSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53RecoveryReadinessClient.lambda$updateResourceSet$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Route53RecoveryReadinessException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends Route53RecoveryReadinessRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.18.23").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Route53RecoveryReadinessRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateResourceSet$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRecoveryGroup$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReadinessCheck$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCell$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResources$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRules$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceSets$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecoveryGroups$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReadinessChecks$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCrossAccountAuthorizations$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCells$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceSet$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecoveryGroupReadinessSummary$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecoveryGroup$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReadinessCheckStatus$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReadinessCheckResourceStatus$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReadinessCheck$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCellReadinessSummary$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCell$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getArchitectureRecommendations$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourceSet$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRecoveryGroup$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReadinessCheck$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCrossAccountAuthorization$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCell$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResourceSet$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRecoveryGroup$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReadinessCheck$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCrossAccountAuthorization$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCell$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

