/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadinessCheckOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadinessCheckOutput> {
    private static final SdkField<String> READINESS_CHECK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadinessCheckArn").getter(ReadinessCheckOutput.getter(ReadinessCheckOutput::readinessCheckArn)).setter(ReadinessCheckOutput.setter(Builder::readinessCheckArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessCheckArn").build()}).build();
    private static final SdkField<String> READINESS_CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadinessCheckName").getter(ReadinessCheckOutput.getter(ReadinessCheckOutput::readinessCheckName)).setter(ReadinessCheckOutput.setter(Builder::readinessCheckName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessCheckName").build()}).build();
    private static final SdkField<String> RESOURCE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceSet").getter(ReadinessCheckOutput.getter(ReadinessCheckOutput::resourceSet)).setter(ReadinessCheckOutput.setter(Builder::resourceSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSet").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ReadinessCheckOutput.getter(ReadinessCheckOutput::tags)).setter(ReadinessCheckOutput.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READINESS_CHECK_ARN_FIELD, READINESS_CHECK_NAME_FIELD, RESOURCE_SET_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String readinessCheckArn;
    private final String readinessCheckName;
    private final String resourceSet;
    private final Map<String, String> tags;

    private ReadinessCheckOutput(BuilderImpl builder) {
        this.readinessCheckArn = builder.readinessCheckArn;
        this.readinessCheckName = builder.readinessCheckName;
        this.resourceSet = builder.resourceSet;
        this.tags = builder.tags;
    }

    public final String readinessCheckArn() {
        return this.readinessCheckArn;
    }

    public final String readinessCheckName() {
        return this.readinessCheckName;
    }

    public final String resourceSet() {
        return this.resourceSet;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessCheckArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessCheckName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadinessCheckOutput)) {
            return false;
        }
        ReadinessCheckOutput other = (ReadinessCheckOutput)obj;
        return Objects.equals(this.readinessCheckArn(), other.readinessCheckArn()) && Objects.equals(this.readinessCheckName(), other.readinessCheckName()) && Objects.equals(this.resourceSet(), other.resourceSet()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ReadinessCheckOutput").add("ReadinessCheckArn", (Object)this.readinessCheckArn()).add("ReadinessCheckName", (Object)this.readinessCheckName()).add("ResourceSet", (Object)this.resourceSet()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReadinessCheckArn": {
                return Optional.ofNullable(clazz.cast(this.readinessCheckArn()));
            }
            case "ReadinessCheckName": {
                return Optional.ofNullable(clazz.cast(this.readinessCheckName()));
            }
            case "ResourceSet": {
                return Optional.ofNullable(clazz.cast(this.resourceSet()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReadinessCheckOutput, T> g) {
        return obj -> g.apply((ReadinessCheckOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String readinessCheckArn;
        private String readinessCheckName;
        private String resourceSet;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReadinessCheckOutput model) {
            this.readinessCheckArn(model.readinessCheckArn);
            this.readinessCheckName(model.readinessCheckName);
            this.resourceSet(model.resourceSet);
            this.tags(model.tags);
        }

        public final String getReadinessCheckArn() {
            return this.readinessCheckArn;
        }

        @Override
        public final Builder readinessCheckArn(String readinessCheckArn) {
            this.readinessCheckArn = readinessCheckArn;
            return this;
        }

        public final void setReadinessCheckArn(String readinessCheckArn) {
            this.readinessCheckArn = readinessCheckArn;
        }

        public final String getReadinessCheckName() {
            return this.readinessCheckName;
        }

        @Override
        public final Builder readinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
            return this;
        }

        public final void setReadinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
        }

        public final String getResourceSet() {
            return this.resourceSet;
        }

        @Override
        public final Builder resourceSet(String resourceSet) {
            this.resourceSet = resourceSet;
            return this;
        }

        public final void setResourceSet(String resourceSet) {
            this.resourceSet = resourceSet;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public ReadinessCheckOutput build() {
            return new ReadinessCheckOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadinessCheckOutput> {
        public Builder readinessCheckArn(String var1);

        public Builder readinessCheckName(String var1);

        public Builder resourceSet(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

