/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class R53ResourceRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, R53ResourceRecord> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(R53ResourceRecord.getter(R53ResourceRecord::domainName)).setter(R53ResourceRecord.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> RECORD_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordSetId").getter(R53ResourceRecord.getter(R53ResourceRecord::recordSetId)).setter(R53ResourceRecord.setter(Builder::recordSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordSetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, RECORD_SET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String recordSetId;

    private R53ResourceRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.recordSetId = builder.recordSetId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String recordSetId() {
        return this.recordSetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordSetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof R53ResourceRecord)) {
            return false;
        }
        R53ResourceRecord other = (R53ResourceRecord)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.recordSetId(), other.recordSetId());
    }

    public final String toString() {
        return ToString.builder((String)"R53ResourceRecord").add("DomainName", (Object)this.domainName()).add("RecordSetId", (Object)this.recordSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "RecordSetId": {
                return Optional.ofNullable(clazz.cast(this.recordSetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<R53ResourceRecord, T> g) {
        return obj -> g.apply((R53ResourceRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String recordSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(R53ResourceRecord model) {
            this.domainName(model.domainName);
            this.recordSetId(model.recordSetId);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getRecordSetId() {
            return this.recordSetId;
        }

        @Override
        public final Builder recordSetId(String recordSetId) {
            this.recordSetId = recordSetId;
            return this;
        }

        public final void setRecordSetId(String recordSetId) {
            this.recordSetId = recordSetId;
        }

        public R53ResourceRecord build() {
            return new R53ResourceRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, R53ResourceRecord> {
        public Builder domainName(String var1);

        public Builder recordSetId(String var1);
    }
}

