/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRulesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListRulesOutput> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ListRulesOutput.getter(ListRulesOutput::resourceType)).setter(ListRulesOutput.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RULE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleDescription").getter(ListRulesOutput.getter(ListRulesOutput::ruleDescription)).setter(ListRulesOutput.setter(Builder::ruleDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDescription").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(ListRulesOutput.getter(ListRulesOutput::ruleId)).setter(ListRulesOutput.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RULE_DESCRIPTION_FIELD, RULE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String ruleDescription;
    private final String ruleId;

    private ListRulesOutput(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.ruleDescription = builder.ruleDescription;
        this.ruleId = builder.ruleId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String ruleDescription() {
        return this.ruleDescription;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesOutput)) {
            return false;
        }
        ListRulesOutput other = (ListRulesOutput)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.ruleDescription(), other.ruleDescription()) && Objects.equals(this.ruleId(), other.ruleId());
    }

    public final String toString() {
        return ToString.builder((String)"ListRulesOutput").add("ResourceType", (Object)this.resourceType()).add("RuleDescription", (Object)this.ruleDescription()).add("RuleId", (Object)this.ruleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "RuleDescription": {
                return Optional.ofNullable(clazz.cast(this.ruleDescription()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRulesOutput, T> g) {
        return obj -> g.apply((ListRulesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String ruleDescription;
        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesOutput model) {
            this.resourceType(model.resourceType);
            this.ruleDescription(model.ruleDescription);
            this.ruleId(model.ruleId);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getRuleDescription() {
            return this.ruleDescription;
        }

        @Override
        public final Builder ruleDescription(String ruleDescription) {
            this.ruleDescription = ruleDescription;
            return this;
        }

        public final void setRuleDescription(String ruleDescription) {
            this.ruleDescription = ruleDescription;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public ListRulesOutput build() {
            return new ListRulesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListRulesOutput> {
        public Builder resourceType(String var1);

        public Builder ruleDescription(String var1);

        public Builder ruleId(String var1);
    }
}

