/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecoveryGroupReadinessSummaryRequest
extends Route53RecoveryReadinessRequest
implements ToCopyableBuilder<Builder, GetRecoveryGroupReadinessSummaryRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetRecoveryGroupReadinessSummaryRequest.getter(GetRecoveryGroupReadinessSummaryRequest::maxResults)).setter(GetRecoveryGroupReadinessSummaryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetRecoveryGroupReadinessSummaryRequest.getter(GetRecoveryGroupReadinessSummaryRequest::nextToken)).setter(GetRecoveryGroupReadinessSummaryRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> RECOVERY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryGroupName").getter(GetRecoveryGroupReadinessSummaryRequest.getter(GetRecoveryGroupReadinessSummaryRequest::recoveryGroupName)).setter(GetRecoveryGroupReadinessSummaryRequest.setter(Builder::recoveryGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("recoveryGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, RECOVERY_GROUP_NAME_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final String recoveryGroupName;

    private GetRecoveryGroupReadinessSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.recoveryGroupName = builder.recoveryGroupName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String recoveryGroupName() {
        return this.recoveryGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryGroupReadinessSummaryRequest)) {
            return false;
        }
        GetRecoveryGroupReadinessSummaryRequest other = (GetRecoveryGroupReadinessSummaryRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.recoveryGroupName(), other.recoveryGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecoveryGroupReadinessSummaryRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("RecoveryGroupName", (Object)this.recoveryGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RecoveryGroupName": {
                return Optional.ofNullable(clazz.cast(this.recoveryGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryGroupReadinessSummaryRequest, T> g) {
        return obj -> g.apply((GetRecoveryGroupReadinessSummaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String recoveryGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryGroupReadinessSummaryRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.recoveryGroupName(model.recoveryGroupName);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRecoveryGroupName() {
            return this.recoveryGroupName;
        }

        @Override
        public final Builder recoveryGroupName(String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
            return this;
        }

        public final void setRecoveryGroupName(String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecoveryGroupReadinessSummaryRequest build() {
            return new GetRecoveryGroupReadinessSummaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecoveryGroupReadinessSummaryRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder recoveryGroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

