/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Readiness;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.RuleResult;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfRuleResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReadinessCheckResourceStatusResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, GetReadinessCheckResourceStatusResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetReadinessCheckResourceStatusResponse.getter(GetReadinessCheckResourceStatusResponse::nextToken)).setter(GetReadinessCheckResourceStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> READINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Readiness").getter(GetReadinessCheckResourceStatusResponse.getter(GetReadinessCheckResourceStatusResponse::readinessAsString)).setter(GetReadinessCheckResourceStatusResponse.setter(Builder::readiness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()}).build();
    private static final SdkField<List<RuleResult>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(GetReadinessCheckResourceStatusResponse.getter(GetReadinessCheckResourceStatusResponse::rules)).setter(GetReadinessCheckResourceStatusResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, READINESS_FIELD, RULES_FIELD));
    private final String nextToken;
    private final String readiness;
    private final List<RuleResult> rules;

    private GetReadinessCheckResourceStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.readiness = builder.readiness;
        this.rules = builder.rules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Readiness readiness() {
        return Readiness.fromValue(this.readiness);
    }

    public final String readinessAsString() {
        return this.readiness;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<RuleResult> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadinessCheckResourceStatusResponse)) {
            return false;
        }
        GetReadinessCheckResourceStatusResponse other = (GetReadinessCheckResourceStatusResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.readinessAsString(), other.readinessAsString()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"GetReadinessCheckResourceStatusResponse").add("NextToken", (Object)this.nextToken()).add("Readiness", (Object)this.readinessAsString()).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Readiness": {
                return Optional.ofNullable(clazz.cast(this.readinessAsString()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReadinessCheckResourceStatusResponse, T> g) {
        return obj -> g.apply((GetReadinessCheckResourceStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String readiness;
        private List<RuleResult> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadinessCheckResourceStatusResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.readiness(model.readiness);
            this.rules(model.rules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getReadiness() {
            return this.readiness;
        }

        @Override
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        public final List<RuleResult.Builder> getRules() {
            List<RuleResult.Builder> result = ___listOfRuleResultCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rules(Collection<RuleResult> rules) {
            this.rules = ___listOfRuleResultCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleResult ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleResult.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (RuleResult)((RuleResult.Builder)RuleResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<RuleResult.BuilderImpl> rules) {
            this.rules = ___listOfRuleResultCopier.copyFromBuilder(rules);
        }

        @Override
        public GetReadinessCheckResourceStatusResponse build() {
            return new GetReadinessCheckResourceStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReadinessCheckResourceStatusResponse> {
        public Builder nextToken(String var1);

        public Builder readiness(String var1);

        public Builder readiness(Readiness var1);

        public Builder rules(Collection<RuleResult> var1);

        public Builder rules(RuleResult ... var1);

        public Builder rules(Consumer<RuleResult.Builder> ... var1);
    }
}

