/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Readiness;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckSummary;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOfReadinessCheckSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCellReadinessSummaryResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, GetCellReadinessSummaryResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCellReadinessSummaryResponse.getter(GetCellReadinessSummaryResponse::nextToken)).setter(GetCellReadinessSummaryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> READINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Readiness").getter(GetCellReadinessSummaryResponse.getter(GetCellReadinessSummaryResponse::readinessAsString)).setter(GetCellReadinessSummaryResponse.setter(Builder::readiness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()}).build();
    private static final SdkField<List<ReadinessCheckSummary>> READINESS_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadinessChecks").getter(GetCellReadinessSummaryResponse.getter(GetCellReadinessSummaryResponse::readinessChecks)).setter(GetCellReadinessSummaryResponse.setter(Builder::readinessChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessChecks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReadinessCheckSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, READINESS_FIELD, READINESS_CHECKS_FIELD));
    private final String nextToken;
    private final String readiness;
    private final List<ReadinessCheckSummary> readinessChecks;

    private GetCellReadinessSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.readiness = builder.readiness;
        this.readinessChecks = builder.readinessChecks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Readiness readiness() {
        return Readiness.fromValue(this.readiness);
    }

    public final String readinessAsString() {
        return this.readiness;
    }

    public final boolean hasReadinessChecks() {
        return this.readinessChecks != null && !(this.readinessChecks instanceof SdkAutoConstructList);
    }

    public final List<ReadinessCheckSummary> readinessChecks() {
        return this.readinessChecks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadinessChecks() ? this.readinessChecks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCellReadinessSummaryResponse)) {
            return false;
        }
        GetCellReadinessSummaryResponse other = (GetCellReadinessSummaryResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.readinessAsString(), other.readinessAsString()) && this.hasReadinessChecks() == other.hasReadinessChecks() && Objects.equals(this.readinessChecks(), other.readinessChecks());
    }

    public final String toString() {
        return ToString.builder((String)"GetCellReadinessSummaryResponse").add("NextToken", (Object)this.nextToken()).add("Readiness", (Object)this.readinessAsString()).add("ReadinessChecks", this.hasReadinessChecks() ? this.readinessChecks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Readiness": {
                return Optional.ofNullable(clazz.cast(this.readinessAsString()));
            }
            case "ReadinessChecks": {
                return Optional.ofNullable(clazz.cast(this.readinessChecks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCellReadinessSummaryResponse, T> g) {
        return obj -> g.apply((GetCellReadinessSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String readiness;
        private List<ReadinessCheckSummary> readinessChecks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCellReadinessSummaryResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.readiness(model.readiness);
            this.readinessChecks(model.readinessChecks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getReadiness() {
            return this.readiness;
        }

        @Override
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        public final List<ReadinessCheckSummary.Builder> getReadinessChecks() {
            List<ReadinessCheckSummary.Builder> result = ___listOfReadinessCheckSummaryCopier.copyToBuilder(this.readinessChecks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder readinessChecks(Collection<ReadinessCheckSummary> readinessChecks) {
            this.readinessChecks = ___listOfReadinessCheckSummaryCopier.copy(readinessChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readinessChecks(ReadinessCheckSummary ... readinessChecks) {
            this.readinessChecks(Arrays.asList(readinessChecks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readinessChecks(Consumer<ReadinessCheckSummary.Builder> ... readinessChecks) {
            this.readinessChecks(Stream.of(readinessChecks).map(c -> (ReadinessCheckSummary)((ReadinessCheckSummary.Builder)ReadinessCheckSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReadinessChecks(Collection<ReadinessCheckSummary.BuilderImpl> readinessChecks) {
            this.readinessChecks = ___listOfReadinessCheckSummaryCopier.copyFromBuilder(readinessChecks);
        }

        @Override
        public GetCellReadinessSummaryResponse build() {
            return new GetCellReadinessSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCellReadinessSummaryResponse> {
        public Builder nextToken(String var1);

        public Builder readiness(String var1);

        public Builder readiness(Readiness var1);

        public Builder readinessChecks(Collection<ReadinessCheckSummary> var1);

        public Builder readinessChecks(ReadinessCheckSummary ... var1);

        public Builder readinessChecks(Consumer<ReadinessCheckSummary.Builder> ... var1);
    }
}

