/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessAsyncClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.RecoveryGroupOutput;

public class ListRecoveryGroupsPublisher
implements SdkPublisher<ListRecoveryGroupsResponse> {
    private final Route53RecoveryReadinessAsyncClient client;
    private final ListRecoveryGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecoveryGroupsPublisher(Route53RecoveryReadinessAsyncClient client, ListRecoveryGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecoveryGroupsPublisher(Route53RecoveryReadinessAsyncClient client, ListRecoveryGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecoveryGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecoveryGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecoveryGroupOutput> recoveryGroups() {
        Function<ListRecoveryGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recoveryGroups() != null) {
                return response.recoveryGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecoveryGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecoveryGroupsResponseFetcher
    implements AsyncPageFetcher<ListRecoveryGroupsResponse> {
        private ListRecoveryGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecoveryGroupsResponse> nextPage(ListRecoveryGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryGroupsPublisher.this.client.listRecoveryGroups(ListRecoveryGroupsPublisher.this.firstRequest);
            }
            return ListRecoveryGroupsPublisher.this.client.listRecoveryGroups((ListRecoveryGroupsRequest)((Object)ListRecoveryGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

