/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.Route53RecoveryControlConfigEndpointParams;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.Route53RecoveryControlConfigEndpointProvider;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultRoute53RecoveryControlConfigEndpointProvider
implements Route53RecoveryControlConfigEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(Route53RecoveryControlConfigEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule6(params, locals);
    }

    private static RuleResult endpointRule1(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule3(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule4(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule5(params, locals);
    }

    private static RuleResult endpointRule4(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule7(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule24(params, locals);
    }

    private static RuleResult endpointRule7(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule8(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule9(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule15(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config.us-west-2.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-west-2").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://arc-recovery-control-config.us-west-2.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-west-2").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule14(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule13(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config-fips." + locals.partitionResult().implicitGlobalRegion() + "." + locals.partitionResult().dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(locals.partitionResult().implicitGlobalRegion()).build())).build());
    }

    private static RuleResult endpointRule14(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule15(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule16(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule17(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config-fips." + locals.partitionResult().implicitGlobalRegion() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(locals.partitionResult().implicitGlobalRegion()).build())).build());
    }

    private static RuleResult endpointRule18(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule19(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule22(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule21(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config." + locals.partitionResult().implicitGlobalRegion() + "." + locals.partitionResult().dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(locals.partitionResult().implicitGlobalRegion()).build())).build());
    }

    private static RuleResult endpointRule22(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule23(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config." + locals.partitionResult().implicitGlobalRegion() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(locals.partitionResult().implicitGlobalRegion()).build())).build());
    }

    private static RuleResult endpointRule24(Route53RecoveryControlConfigEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

