/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingControl> {
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelArn").getter(RoutingControl.getter(RoutingControl::controlPanelArn)).setter(RoutingControl.setter(Builder::controlPanelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RoutingControl.getter(RoutingControl::name)).setter(RoutingControl.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlArn").getter(RoutingControl.getter(RoutingControl::routingControlArn)).setter(RoutingControl.setter(Builder::routingControlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RoutingControl.getter(RoutingControl::statusAsString)).setter(RoutingControl.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(RoutingControl.getter(RoutingControl::owner)).setter(RoutingControl.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_ARN_FIELD, NAME_FIELD, ROUTING_CONTROL_ARN_FIELD, STATUS_FIELD, OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoutingControl.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String controlPanelArn;
    private final String name;
    private final String routingControlArn;
    private final String status;
    private final String owner;

    private RoutingControl(BuilderImpl builder) {
        this.controlPanelArn = builder.controlPanelArn;
        this.name = builder.name;
        this.routingControlArn = builder.routingControlArn;
        this.status = builder.status;
        this.owner = builder.owner;
    }

    public final String controlPanelArn() {
        return this.controlPanelArn;
    }

    public final String name() {
        return this.name;
    }

    public final String routingControlArn() {
        return this.routingControlArn;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingControl)) {
            return false;
        }
        RoutingControl other = (RoutingControl)obj;
        return Objects.equals(this.controlPanelArn(), other.controlPanelArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.routingControlArn(), other.routingControlArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.owner(), other.owner());
    }

    public final String toString() {
        return ToString.builder((String)"RoutingControl").add("ControlPanelArn", (Object)this.controlPanelArn()).add("Name", (Object)this.name()).add("RoutingControlArn", (Object)this.routingControlArn()).add("Status", (Object)this.statusAsString()).add("Owner", (Object)this.owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlPanelArn": {
                return Optional.ofNullable(clazz.cast(this.controlPanelArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoutingControlArn": {
                return Optional.ofNullable(clazz.cast(this.routingControlArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ControlPanelArn", CONTROL_PANEL_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RoutingControlArn", ROUTING_CONTROL_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingControl, T> g) {
        return obj -> g.apply((RoutingControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlPanelArn;
        private String name;
        private String routingControlArn;
        private String status;
        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingControl model) {
            this.controlPanelArn(model.controlPanelArn);
            this.name(model.name);
            this.routingControlArn(model.routingControlArn);
            this.status(model.status);
            this.owner(model.owner);
        }

        public final String getControlPanelArn() {
            return this.controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoutingControlArn() {
            return this.routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public RoutingControl build() {
            return new RoutingControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingControl> {
        public Builder controlPanelArn(String var1);

        public Builder name(String var1);

        public Builder routingControlArn(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder owner(String var1);
    }
}

