/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleConfig;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.___listOf__stringMin1Max256PatternAZaZ09Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NewGatingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NewGatingRule> {
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelArn").getter(NewGatingRule.getter(NewGatingRule::controlPanelArn)).setter(NewGatingRule.setter(Builder::controlPanelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()}).build();
    private static final SdkField<List<String>> GATING_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatingControls").getter(NewGatingRule.getter(NewGatingRule::gatingControls)).setter(NewGatingRule.setter(Builder::gatingControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatingControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(NewGatingRule.getter(NewGatingRule::name)).setter(NewGatingRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RuleConfig> RULE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleConfig").getter(NewGatingRule.getter(NewGatingRule::ruleConfig)).setter(NewGatingRule.setter(Builder::ruleConfig)).constructor(RuleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleConfig").build()}).build();
    private static final SdkField<List<String>> TARGET_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetControls").getter(NewGatingRule.getter(NewGatingRule::targetControls)).setter(NewGatingRule.setter(Builder::targetControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> WAIT_PERIOD_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitPeriodMs").getter(NewGatingRule.getter(NewGatingRule::waitPeriodMs)).setter(NewGatingRule.setter(Builder::waitPeriodMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitPeriodMs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_PANEL_ARN_FIELD, GATING_CONTROLS_FIELD, NAME_FIELD, RULE_CONFIG_FIELD, TARGET_CONTROLS_FIELD, WAIT_PERIOD_MS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ControlPanelArn", CONTROL_PANEL_ARN_FIELD);
            this.put("GatingControls", GATING_CONTROLS_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("RuleConfig", RULE_CONFIG_FIELD);
            this.put("TargetControls", TARGET_CONTROLS_FIELD);
            this.put("WaitPeriodMs", WAIT_PERIOD_MS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String controlPanelArn;
    private final List<String> gatingControls;
    private final String name;
    private final RuleConfig ruleConfig;
    private final List<String> targetControls;
    private final Integer waitPeriodMs;

    private NewGatingRule(BuilderImpl builder) {
        this.controlPanelArn = builder.controlPanelArn;
        this.gatingControls = builder.gatingControls;
        this.name = builder.name;
        this.ruleConfig = builder.ruleConfig;
        this.targetControls = builder.targetControls;
        this.waitPeriodMs = builder.waitPeriodMs;
    }

    public final String controlPanelArn() {
        return this.controlPanelArn;
    }

    public final boolean hasGatingControls() {
        return this.gatingControls != null && !(this.gatingControls instanceof SdkAutoConstructList);
    }

    public final List<String> gatingControls() {
        return this.gatingControls;
    }

    public final String name() {
        return this.name;
    }

    public final RuleConfig ruleConfig() {
        return this.ruleConfig;
    }

    public final boolean hasTargetControls() {
        return this.targetControls != null && !(this.targetControls instanceof SdkAutoConstructList);
    }

    public final List<String> targetControls() {
        return this.targetControls;
    }

    public final Integer waitPeriodMs() {
        return this.waitPeriodMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatingControls() ? this.gatingControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetControls() ? this.targetControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.waitPeriodMs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewGatingRule)) {
            return false;
        }
        NewGatingRule other = (NewGatingRule)obj;
        return Objects.equals(this.controlPanelArn(), other.controlPanelArn()) && this.hasGatingControls() == other.hasGatingControls() && Objects.equals(this.gatingControls(), other.gatingControls()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleConfig(), other.ruleConfig()) && this.hasTargetControls() == other.hasTargetControls() && Objects.equals(this.targetControls(), other.targetControls()) && Objects.equals(this.waitPeriodMs(), other.waitPeriodMs());
    }

    public final String toString() {
        return ToString.builder((String)"NewGatingRule").add("ControlPanelArn", (Object)this.controlPanelArn()).add("GatingControls", this.hasGatingControls() ? this.gatingControls() : null).add("Name", (Object)this.name()).add("RuleConfig", (Object)this.ruleConfig()).add("TargetControls", this.hasTargetControls() ? this.targetControls() : null).add("WaitPeriodMs", (Object)this.waitPeriodMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlPanelArn": {
                return Optional.ofNullable(clazz.cast(this.controlPanelArn()));
            }
            case "GatingControls": {
                return Optional.ofNullable(clazz.cast(this.gatingControls()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleConfig": {
                return Optional.ofNullable(clazz.cast(this.ruleConfig()));
            }
            case "TargetControls": {
                return Optional.ofNullable(clazz.cast(this.targetControls()));
            }
            case "WaitPeriodMs": {
                return Optional.ofNullable(clazz.cast(this.waitPeriodMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NewGatingRule, T> g) {
        return obj -> g.apply((NewGatingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlPanelArn;
        private List<String> gatingControls = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private RuleConfig ruleConfig;
        private List<String> targetControls = DefaultSdkAutoConstructList.getInstance();
        private Integer waitPeriodMs;

        private BuilderImpl() {
        }

        private BuilderImpl(NewGatingRule model) {
            this.controlPanelArn(model.controlPanelArn);
            this.gatingControls(model.gatingControls);
            this.name(model.name);
            this.ruleConfig(model.ruleConfig);
            this.targetControls(model.targetControls);
            this.waitPeriodMs(model.waitPeriodMs);
        }

        public final String getControlPanelArn() {
            return this.controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final Collection<String> getGatingControls() {
            if (this.gatingControls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatingControls;
        }

        public final void setGatingControls(Collection<String> gatingControls) {
            this.gatingControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(gatingControls);
        }

        @Override
        public final Builder gatingControls(Collection<String> gatingControls) {
            this.gatingControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(gatingControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatingControls(String ... gatingControls) {
            this.gatingControls(Arrays.asList(gatingControls));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleConfig.Builder getRuleConfig() {
            return this.ruleConfig != null ? this.ruleConfig.toBuilder() : null;
        }

        public final void setRuleConfig(RuleConfig.BuilderImpl ruleConfig) {
            this.ruleConfig = ruleConfig != null ? ruleConfig.build() : null;
        }

        @Override
        public final Builder ruleConfig(RuleConfig ruleConfig) {
            this.ruleConfig = ruleConfig;
            return this;
        }

        public final Collection<String> getTargetControls() {
            if (this.targetControls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetControls;
        }

        public final void setTargetControls(Collection<String> targetControls) {
            this.targetControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(targetControls);
        }

        @Override
        public final Builder targetControls(Collection<String> targetControls) {
            this.targetControls = ___listOf__stringMin1Max256PatternAZaZ09Copier.copy(targetControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetControls(String ... targetControls) {
            this.targetControls(Arrays.asList(targetControls));
            return this;
        }

        public final Integer getWaitPeriodMs() {
            return this.waitPeriodMs;
        }

        public final void setWaitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
        }

        @Override
        public final Builder waitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
            return this;
        }

        public NewGatingRule build() {
            return new NewGatingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NewGatingRule> {
        public Builder controlPanelArn(String var1);

        public Builder gatingControls(Collection<String> var1);

        public Builder gatingControls(String ... var1);

        public Builder name(String var1);

        public Builder ruleConfig(RuleConfig var1);

        default public Builder ruleConfig(Consumer<RuleConfig.Builder> ruleConfig) {
            return this.ruleConfig((RuleConfig)((RuleConfig.Builder)RuleConfig.builder().applyMutation(ruleConfig)).build());
        }

        public Builder targetControls(Collection<String> var1);

        public Builder targetControls(String ... var1);

        public Builder waitPeriodMs(Integer var1);
    }
}

