/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.RuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleConfig> {
    private static final SdkField<Boolean> INVERTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Inverted").getter(RuleConfig.getter(RuleConfig::inverted)).setter(RuleConfig.setter(Builder::inverted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverted").build()}).build();
    private static final SdkField<Integer> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Threshold").getter(RuleConfig.getter(RuleConfig::threshold)).setter(RuleConfig.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RuleConfig.getter(RuleConfig::typeAsString)).setter(RuleConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVERTED_FIELD, THRESHOLD_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean inverted;
    private final Integer threshold;
    private final String type;

    private RuleConfig(BuilderImpl builder) {
        this.inverted = builder.inverted;
        this.threshold = builder.threshold;
        this.type = builder.type;
    }

    public final Boolean inverted() {
        return this.inverted;
    }

    public final Integer threshold() {
        return this.threshold;
    }

    public final RuleType type() {
        return RuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inverted());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleConfig)) {
            return false;
        }
        RuleConfig other = (RuleConfig)obj;
        return Objects.equals(this.inverted(), other.inverted()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RuleConfig").add("Inverted", (Object)this.inverted()).add("Threshold", (Object)this.threshold()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Inverted": {
                return Optional.ofNullable(clazz.cast(this.inverted()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Inverted", INVERTED_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleConfig, T> g) {
        return obj -> g.apply((RuleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean inverted;
        private Integer threshold;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleConfig model) {
            this.inverted(model.inverted);
            this.threshold(model.threshold);
            this.type(model.type);
        }

        public final Boolean getInverted() {
            return this.inverted;
        }

        public final void setInverted(Boolean inverted) {
            this.inverted = inverted;
        }

        @Override
        public final Builder inverted(Boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public final Integer getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Integer threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Integer threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RuleConfig build() {
            return new RuleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleConfig> {
        public Builder inverted(Boolean var1);

        public Builder threshold(Integer var1);

        public Builder type(String var1);

        public Builder type(RuleType var1);
    }
}

