/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule;

public class ListSafetyRulesIterable
implements SdkIterable<ListSafetyRulesResponse> {
    private final Route53RecoveryControlConfigClient client;
    private final ListSafetyRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSafetyRulesIterable(Route53RecoveryControlConfigClient client, ListSafetyRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSafetyRulesResponseFetcher();
    }

    public Iterator<ListSafetyRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Rule> safetyRules() {
        Function<ListSafetyRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.safetyRules() != null) {
                return response.safetyRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSafetyRulesResponseFetcher
    implements SyncPageFetcher<ListSafetyRulesResponse> {
        private ListSafetyRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSafetyRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSafetyRulesResponse nextPage(ListSafetyRulesResponse previousPage) {
            if (previousPage == null) {
                return ListSafetyRulesIterable.this.client.listSafetyRules(ListSafetyRulesIterable.this.firstRequest);
            }
            return ListSafetyRulesIterable.this.client.listSafetyRules((ListSafetyRulesRequest)((Object)ListSafetyRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

