/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatingRuleUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatingRuleUpdate> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GatingRuleUpdate.getter(GatingRuleUpdate::name)).setter(GatingRuleUpdate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SAFETY_RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SafetyRuleArn").getter(GatingRuleUpdate.getter(GatingRuleUpdate::safetyRuleArn)).setter(GatingRuleUpdate.setter(Builder::safetyRuleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRuleArn").build()}).build();
    private static final SdkField<Integer> WAIT_PERIOD_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitPeriodMs").getter(GatingRuleUpdate.getter(GatingRuleUpdate::waitPeriodMs)).setter(GatingRuleUpdate.setter(Builder::waitPeriodMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitPeriodMs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SAFETY_RULE_ARN_FIELD, WAIT_PERIOD_MS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String safetyRuleArn;
    private final Integer waitPeriodMs;

    private GatingRuleUpdate(BuilderImpl builder) {
        this.name = builder.name;
        this.safetyRuleArn = builder.safetyRuleArn;
        this.waitPeriodMs = builder.waitPeriodMs;
    }

    public final String name() {
        return this.name;
    }

    public final String safetyRuleArn() {
        return this.safetyRuleArn;
    }

    public final Integer waitPeriodMs() {
        return this.waitPeriodMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.safetyRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitPeriodMs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatingRuleUpdate)) {
            return false;
        }
        GatingRuleUpdate other = (GatingRuleUpdate)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.safetyRuleArn(), other.safetyRuleArn()) && Objects.equals(this.waitPeriodMs(), other.waitPeriodMs());
    }

    public final String toString() {
        return ToString.builder((String)"GatingRuleUpdate").add("Name", (Object)this.name()).add("SafetyRuleArn", (Object)this.safetyRuleArn()).add("WaitPeriodMs", (Object)this.waitPeriodMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SafetyRuleArn": {
                return Optional.ofNullable(clazz.cast(this.safetyRuleArn()));
            }
            case "WaitPeriodMs": {
                return Optional.ofNullable(clazz.cast(this.waitPeriodMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatingRuleUpdate, T> g) {
        return obj -> g.apply((GatingRuleUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String safetyRuleArn;
        private Integer waitPeriodMs;

        private BuilderImpl() {
        }

        private BuilderImpl(GatingRuleUpdate model) {
            this.name(model.name);
            this.safetyRuleArn(model.safetyRuleArn);
            this.waitPeriodMs(model.waitPeriodMs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSafetyRuleArn() {
            return this.safetyRuleArn;
        }

        public final void setSafetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
        }

        @Override
        public final Builder safetyRuleArn(String safetyRuleArn) {
            this.safetyRuleArn = safetyRuleArn;
            return this;
        }

        public final Integer getWaitPeriodMs() {
            return this.waitPeriodMs;
        }

        public final void setWaitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
        }

        @Override
        public final Builder waitPeriodMs(Integer waitPeriodMs) {
            this.waitPeriodMs = waitPeriodMs;
            return this;
        }

        public GatingRuleUpdate build() {
            return new GatingRuleUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatingRuleUpdate> {
        public Builder name(String var1);

        public Builder safetyRuleArn(String var1);

        public Builder waitPeriodMs(Integer var1);
    }
}

