/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control panel represents a group of routing controls that can be changed together in a single transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ControlPanel implements SdkPojo, Serializable, ToCopyableBuilder<ControlPanel.Builder, ControlPanel> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(ControlPanel::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlPanelArn").getter(getter(ControlPanel::controlPanelArn)).setter(setter(Builder::controlPanelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()).build();

    private static final SdkField<Boolean> DEFAULT_CONTROL_PANEL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultControlPanel").getter(getter(ControlPanel::defaultControlPanel))
            .setter(setter(Builder::defaultControlPanel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultControlPanel").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ControlPanel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> ROUTING_CONTROL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RoutingControlCount").getter(getter(ControlPanel::routingControlCount))
            .setter(setter(Builder::routingControlCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlCount").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ControlPanel::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CONTROL_PANEL_ARN_FIELD, DEFAULT_CONTROL_PANEL_FIELD, NAME_FIELD, ROUTING_CONTROL_COUNT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final String controlPanelArn;

    private final Boolean defaultControlPanel;

    private final String name;

    private final Integer routingControlCount;

    private final String status;

    private ControlPanel(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.controlPanelArn = builder.controlPanelArn;
        this.defaultControlPanel = builder.defaultControlPanel;
        this.name = builder.name;
        this.routingControlCount = builder.routingControlCount;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster that includes the control panel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster that includes the control panel.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the control panel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the control panel.
     */
    public final String controlPanelArn() {
        return controlPanelArn;
    }

    /**
     * <p>
     * A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default control panel
     * for a cluster. When you create a cluster, Amazon Route 53 Application Recovery Controller creates a control
     * panel, and sets this flag for that control panel. If you create a control panel yourself, this flag is set to
     * false.
     * </p>
     * 
     * @return A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default control
     *         panel for a cluster. When you create a cluster, Amazon Route 53 Application Recovery Controller creates a
     *         control panel, and sets this flag for that control panel. If you create a control panel yourself, this
     *         flag is set to false.
     */
    public final Boolean defaultControlPanel() {
        return defaultControlPanel;
    }

    /**
     * <p>
     * The name of the control panel. You can use any non-white space character in the name.
     * </p>
     * 
     * @return The name of the control panel. You can use any non-white space character in the name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The number of routing controls in the control panel.
     * </p>
     * 
     * @return The number of routing controls in the control panel.
     */
    public final Integer routingControlCount() {
        return routingControlCount;
    }

    /**
     * <p>
     * The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED,
     *         PENDING_DELETION.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED, PENDING_DELETION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED,
     *         PENDING_DELETION.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultControlPanel());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(routingControlCount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlPanel)) {
            return false;
        }
        ControlPanel other = (ControlPanel) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(controlPanelArn(), other.controlPanelArn())
                && Objects.equals(defaultControlPanel(), other.defaultControlPanel()) && Objects.equals(name(), other.name())
                && Objects.equals(routingControlCount(), other.routingControlCount())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ControlPanel").add("ClusterArn", clusterArn()).add("ControlPanelArn", controlPanelArn())
                .add("DefaultControlPanel", defaultControlPanel()).add("Name", name())
                .add("RoutingControlCount", routingControlCount()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ControlPanelArn":
            return Optional.ofNullable(clazz.cast(controlPanelArn()));
        case "DefaultControlPanel":
            return Optional.ofNullable(clazz.cast(defaultControlPanel()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoutingControlCount":
            return Optional.ofNullable(clazz.cast(routingControlCount()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlPanel, T> g) {
        return obj -> g.apply((ControlPanel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ControlPanel> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster that includes the control panel.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the cluster that includes the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the control panel.
         * </p>
         * 
         * @param controlPanelArn
         *        The Amazon Resource Name (ARN) of the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlPanelArn(String controlPanelArn);

        /**
         * <p>
         * A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default control
         * panel for a cluster. When you create a cluster, Amazon Route 53 Application Recovery Controller creates a
         * control panel, and sets this flag for that control panel. If you create a control panel yourself, this flag
         * is set to false.
         * </p>
         * 
         * @param defaultControlPanel
         *        A flag that Amazon Route 53 Application Recovery Controller sets to true to designate the default
         *        control panel for a cluster. When you create a cluster, Amazon Route 53 Application Recovery
         *        Controller creates a control panel, and sets this flag for that control panel. If you create a control
         *        panel yourself, this flag is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultControlPanel(Boolean defaultControlPanel);

        /**
         * <p>
         * The name of the control panel. You can use any non-white space character in the name.
         * </p>
         * 
         * @param name
         *        The name of the control panel. You can use any non-white space character in the name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of routing controls in the control panel.
         * </p>
         * 
         * @param routingControlCount
         *        The number of routing controls in the control panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlCount(Integer routingControlCount);

        /**
         * <p>
         * The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED,
         * PENDING_DELETION.
         * </p>
         * 
         * @param status
         *        The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED,
         *        PENDING_DELETION.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED,
         * PENDING_DELETION.
         * </p>
         * 
         * @param status
         *        The deployment status of control panel. Status can be one of the following: PENDING, DEPLOYED,
         *        PENDING_DELETION.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private String controlPanelArn;

        private Boolean defaultControlPanel;

        private String name;

        private Integer routingControlCount;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlPanel model) {
            clusterArn(model.clusterArn);
            controlPanelArn(model.controlPanelArn);
            defaultControlPanel(model.defaultControlPanel);
            name(model.name);
            routingControlCount(model.routingControlCount);
            status(model.status);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getControlPanelArn() {
            return controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final Boolean getDefaultControlPanel() {
            return defaultControlPanel;
        }

        public final void setDefaultControlPanel(Boolean defaultControlPanel) {
            this.defaultControlPanel = defaultControlPanel;
        }

        @Override
        public final Builder defaultControlPanel(Boolean defaultControlPanel) {
            this.defaultControlPanel = defaultControlPanel;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getRoutingControlCount() {
            return routingControlCount;
        }

        public final void setRoutingControlCount(Integer routingControlCount) {
            this.routingControlCount = routingControlCount;
        }

        @Override
        public final Builder routingControlCount(Integer routingControlCount) {
            this.routingControlCount = routingControlCount;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ControlPanel build() {
            return new ControlPanel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
