/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateControlPanelRequest
extends Route53RecoveryControlConfigRequest
implements ToCopyableBuilder<Builder, CreateControlPanelRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateControlPanelRequest.getter(CreateControlPanelRequest::clientToken)).setter(CreateControlPanelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(CreateControlPanelRequest.getter(CreateControlPanelRequest::clusterArn)).setter(CreateControlPanelRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<String> CONTROL_PANEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelName").getter(CreateControlPanelRequest.getter(CreateControlPanelRequest::controlPanelName)).setter(CreateControlPanelRequest.setter(Builder::controlPanelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CLUSTER_ARN_FIELD, CONTROL_PANEL_NAME_FIELD));
    private final String clientToken;
    private final String clusterArn;
    private final String controlPanelName;

    private CreateControlPanelRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.clusterArn = builder.clusterArn;
        this.controlPanelName = builder.controlPanelName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String controlPanelName() {
        return this.controlPanelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateControlPanelRequest)) {
            return false;
        }
        CreateControlPanelRequest other = (CreateControlPanelRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.controlPanelName(), other.controlPanelName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateControlPanelRequest").add("ClientToken", (Object)this.clientToken()).add("ClusterArn", (Object)this.clusterArn()).add("ControlPanelName", (Object)this.controlPanelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ControlPanelName": {
                return Optional.ofNullable(clazz.cast(this.controlPanelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateControlPanelRequest, T> g) {
        return obj -> g.apply((CreateControlPanelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryControlConfigRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String clusterArn;
        private String controlPanelName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateControlPanelRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.clusterArn(model.clusterArn);
            this.controlPanelName(model.controlPanelName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        @Transient
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getControlPanelName() {
            return this.controlPanelName;
        }

        public final void setControlPanelName(String controlPanelName) {
            this.controlPanelName = controlPanelName;
        }

        @Override
        @Transient
        public final Builder controlPanelName(String controlPanelName) {
            this.controlPanelName = controlPanelName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateControlPanelRequest build() {
            return new CreateControlPanelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryControlConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateControlPanelRequest> {
        public Builder clientToken(String var1);

        public Builder clusterArn(String var1);

        public Builder controlPanelName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

