/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RuleType {
    ATLEAST("ATLEAST"),
    AND("AND"),
    OR("OR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RuleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RuleType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleType> knownValues() {
        return Stream.of(RuleType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

