/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse;

public class ListControlPanelsIterable
implements SdkIterable<ListControlPanelsResponse> {
    private final Route53RecoveryControlConfigClient client;
    private final ListControlPanelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListControlPanelsIterable(Route53RecoveryControlConfigClient client, ListControlPanelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListControlPanelsResponseFetcher();
    }

    public Iterator<ListControlPanelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListControlPanelsResponseFetcher
    implements SyncPageFetcher<ListControlPanelsResponse> {
        private ListControlPanelsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlPanelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListControlPanelsResponse nextPage(ListControlPanelsResponse previousPage) {
            if (previousPage == null) {
                return ListControlPanelsIterable.this.client.listControlPanels(ListControlPanelsIterable.this.firstRequest);
            }
            return ListControlPanelsIterable.this.client.listControlPanels((ListControlPanelsRequest)((Object)ListControlPanelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

