/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlPanel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlPanel> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ControlPanel.getter(ControlPanel::clusterArn)).setter(ControlPanel.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelArn").getter(ControlPanel.getter(ControlPanel::controlPanelArn)).setter(ControlPanel.setter(Builder::controlPanelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()}).build();
    private static final SdkField<Boolean> DEFAULT_CONTROL_PANEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultControlPanel").getter(ControlPanel.getter(ControlPanel::defaultControlPanel)).setter(ControlPanel.setter(Builder::defaultControlPanel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultControlPanel").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ControlPanel.getter(ControlPanel::name)).setter(ControlPanel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> ROUTING_CONTROL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RoutingControlCount").getter(ControlPanel.getter(ControlPanel::routingControlCount)).setter(ControlPanel.setter(Builder::routingControlCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ControlPanel.getter(ControlPanel::statusAsString)).setter(ControlPanel.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CONTROL_PANEL_ARN_FIELD, DEFAULT_CONTROL_PANEL_FIELD, NAME_FIELD, ROUTING_CONTROL_COUNT_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String controlPanelArn;
    private final Boolean defaultControlPanel;
    private final String name;
    private final Integer routingControlCount;
    private final String status;

    private ControlPanel(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.controlPanelArn = builder.controlPanelArn;
        this.defaultControlPanel = builder.defaultControlPanel;
        this.name = builder.name;
        this.routingControlCount = builder.routingControlCount;
        this.status = builder.status;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String controlPanelArn() {
        return this.controlPanelArn;
    }

    public final Boolean defaultControlPanel() {
        return this.defaultControlPanel;
    }

    public final String name() {
        return this.name;
    }

    public final Integer routingControlCount() {
        return this.routingControlCount;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultControlPanel());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlPanel)) {
            return false;
        }
        ControlPanel other = (ControlPanel)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.controlPanelArn(), other.controlPanelArn()) && Objects.equals(this.defaultControlPanel(), other.defaultControlPanel()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.routingControlCount(), other.routingControlCount()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ControlPanel").add("ClusterArn", (Object)this.clusterArn()).add("ControlPanelArn", (Object)this.controlPanelArn()).add("DefaultControlPanel", (Object)this.defaultControlPanel()).add("Name", (Object)this.name()).add("RoutingControlCount", (Object)this.routingControlCount()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ControlPanelArn": {
                return Optional.ofNullable(clazz.cast(this.controlPanelArn()));
            }
            case "DefaultControlPanel": {
                return Optional.ofNullable(clazz.cast(this.defaultControlPanel()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoutingControlCount": {
                return Optional.ofNullable(clazz.cast(this.routingControlCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlPanel, T> g) {
        return obj -> g.apply((ControlPanel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String controlPanelArn;
        private Boolean defaultControlPanel;
        private String name;
        private Integer routingControlCount;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlPanel model) {
            this.clusterArn(model.clusterArn);
            this.controlPanelArn(model.controlPanelArn);
            this.defaultControlPanel(model.defaultControlPanel);
            this.name(model.name);
            this.routingControlCount(model.routingControlCount);
            this.status(model.status);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        @Transient
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getControlPanelArn() {
            return this.controlPanelArn;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        @Override
        @Transient
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final Boolean getDefaultControlPanel() {
            return this.defaultControlPanel;
        }

        public final void setDefaultControlPanel(Boolean defaultControlPanel) {
            this.defaultControlPanel = defaultControlPanel;
        }

        @Override
        @Transient
        public final Builder defaultControlPanel(Boolean defaultControlPanel) {
            this.defaultControlPanel = defaultControlPanel;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getRoutingControlCount() {
            return this.routingControlCount;
        }

        public final void setRoutingControlCount(Integer routingControlCount) {
            this.routingControlCount = routingControlCount;
        }

        @Override
        @Transient
        public final Builder routingControlCount(Integer routingControlCount) {
            this.routingControlCount = routingControlCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ControlPanel build() {
            return new ControlPanel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlPanel> {
        public Builder clusterArn(String var1);

        public Builder controlPanelArn(String var1);

        public Builder defaultControlPanel(Boolean var1);

        public Builder name(String var1);

        public Builder routingControlCount(Integer var1);

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

