/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.AssertionRule;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.GatingRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<AssertionRule> ASSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ASSERTION").getter(Rule.getter(Rule::assertion)).setter(Rule.setter(Builder::assertion)).constructor(AssertionRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ASSERTION").build()}).build();
    private static final SdkField<GatingRule> GATING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GATING").getter(Rule.getter(Rule::gating)).setter(Rule.setter(Builder::gating)).constructor(GatingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GATING").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSERTION_FIELD, GATING_FIELD));
    private static final long serialVersionUID = 1L;
    private final AssertionRule assertion;
    private final GatingRule gating;

    private Rule(BuilderImpl builder) {
        this.assertion = builder.assertion;
        this.gating = builder.gating;
    }

    public final AssertionRule assertion() {
        return this.assertion;
    }

    public final GatingRule gating() {
        return this.gating;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assertion());
        hashCode = 31 * hashCode + Objects.hashCode(this.gating());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.assertion(), other.assertion()) && Objects.equals(this.gating(), other.gating());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("ASSERTION", (Object)this.assertion()).add("GATING", (Object)this.gating()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ASSERTION": {
                return Optional.ofNullable(clazz.cast(this.assertion()));
            }
            case "GATING": {
                return Optional.ofNullable(clazz.cast(this.gating()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssertionRule assertion;
        private GatingRule gating;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.assertion(model.assertion);
            this.gating(model.gating);
        }

        public final AssertionRule.Builder getAssertion() {
            return this.assertion != null ? this.assertion.toBuilder() : null;
        }

        public final void setAssertion(AssertionRule.BuilderImpl assertion) {
            this.assertion = assertion != null ? assertion.build() : null;
        }

        @Override
        @Transient
        public final Builder assertion(AssertionRule assertion) {
            this.assertion = assertion;
            return this;
        }

        public final GatingRule.Builder getGating() {
            return this.gating != null ? this.gating.toBuilder() : null;
        }

        public final void setGating(GatingRule.BuilderImpl gating) {
            this.gating = gating != null ? gating.build() : null;
        }

        @Override
        @Transient
        public final Builder gating(GatingRule gating) {
            this.gating = gating;
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder assertion(AssertionRule var1);

        default public Builder assertion(Consumer<AssertionRule.Builder> assertion) {
            return this.assertion((AssertionRule)((AssertionRule.Builder)AssertionRule.builder().applyMutation(assertion)).build());
        }

        public Builder gating(GatingRule var1);

        default public Builder gating(Consumer<GatingRule.Builder> gating) {
            return this.gating((GatingRule)((GatingRule.Builder)GatingRule.builder().applyMutation(gating)).build());
        }
    }
}

