/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRoutingControlRequest
extends Route53RecoveryControlConfigRequest
implements ToCopyableBuilder<Builder, CreateRoutingControlRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateRoutingControlRequest.getter(CreateRoutingControlRequest::clientToken)).setter(CreateRoutingControlRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(CreateRoutingControlRequest.getter(CreateRoutingControlRequest::clusterArn)).setter(CreateRoutingControlRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<String> CONTROL_PANEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlPanelArn").getter(CreateRoutingControlRequest.getter(CreateRoutingControlRequest::controlPanelArn)).setter(CreateRoutingControlRequest.setter(Builder::controlPanelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlPanelArn").build()}).build();
    private static final SdkField<String> ROUTING_CONTROL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlName").getter(CreateRoutingControlRequest.getter(CreateRoutingControlRequest::routingControlName)).setter(CreateRoutingControlRequest.setter(Builder::routingControlName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CLUSTER_ARN_FIELD, CONTROL_PANEL_ARN_FIELD, ROUTING_CONTROL_NAME_FIELD));
    private final String clientToken;
    private final String clusterArn;
    private final String controlPanelArn;
    private final String routingControlName;

    private CreateRoutingControlRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.clusterArn = builder.clusterArn;
        this.controlPanelArn = builder.controlPanelArn;
        this.routingControlName = builder.routingControlName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String controlPanelArn() {
        return this.controlPanelArn;
    }

    public final String routingControlName() {
        return this.routingControlName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlPanelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoutingControlRequest)) {
            return false;
        }
        CreateRoutingControlRequest other = (CreateRoutingControlRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.controlPanelArn(), other.controlPanelArn()) && Objects.equals(this.routingControlName(), other.routingControlName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRoutingControlRequest").add("ClientToken", (Object)this.clientToken()).add("ClusterArn", (Object)this.clusterArn()).add("ControlPanelArn", (Object)this.controlPanelArn()).add("RoutingControlName", (Object)this.routingControlName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ControlPanelArn": {
                return Optional.ofNullable(clazz.cast(this.controlPanelArn()));
            }
            case "RoutingControlName": {
                return Optional.ofNullable(clazz.cast(this.routingControlName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoutingControlRequest, T> g) {
        return obj -> g.apply((CreateRoutingControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryControlConfigRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String clusterArn;
        private String controlPanelArn;
        private String routingControlName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoutingControlRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.clusterArn(model.clusterArn);
            this.controlPanelArn(model.controlPanelArn);
            this.routingControlName(model.routingControlName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getControlPanelArn() {
            return this.controlPanelArn;
        }

        @Override
        public final Builder controlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        public final void setControlPanelArn(String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
        }

        public final String getRoutingControlName() {
            return this.routingControlName;
        }

        @Override
        public final Builder routingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
            return this;
        }

        public final void setRoutingControlName(String routingControlName) {
            this.routingControlName = routingControlName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoutingControlRequest build() {
            return new CreateRoutingControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryControlConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRoutingControlRequest> {
        public Builder clientToken(String var1);

        public Builder clusterArn(String var1);

        public Builder controlPanelArn(String var1);

        public Builder routingControlName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

