/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycluster.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoverycluster.model.ArnsCopier;
import software.amazon.awssdk.services.route53recoverycluster.model.Route53RecoveryClusterRequest;
import software.amazon.awssdk.services.route53recoverycluster.model.RoutingControlState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoutingControlStateRequest
extends Route53RecoveryClusterRequest
implements ToCopyableBuilder<Builder, UpdateRoutingControlStateRequest> {
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlArn").getter(UpdateRoutingControlStateRequest.getter(UpdateRoutingControlStateRequest::routingControlArn)).setter(UpdateRoutingControlStateRequest.setter(Builder::routingControlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlArn").build()}).build();
    private static final SdkField<String> ROUTING_CONTROL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingControlState").getter(UpdateRoutingControlStateRequest.getter(UpdateRoutingControlStateRequest::routingControlStateAsString)).setter(UpdateRoutingControlStateRequest.setter(Builder::routingControlState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingControlState").build()}).build();
    private static final SdkField<List<String>> SAFETY_RULES_TO_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SafetyRulesToOverride").getter(UpdateRoutingControlStateRequest.getter(UpdateRoutingControlStateRequest::safetyRulesToOverride)).setter(UpdateRoutingControlStateRequest.setter(Builder::safetyRulesToOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRulesToOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_CONTROL_ARN_FIELD, ROUTING_CONTROL_STATE_FIELD, SAFETY_RULES_TO_OVERRIDE_FIELD));
    private final String routingControlArn;
    private final String routingControlState;
    private final List<String> safetyRulesToOverride;

    private UpdateRoutingControlStateRequest(BuilderImpl builder) {
        super(builder);
        this.routingControlArn = builder.routingControlArn;
        this.routingControlState = builder.routingControlState;
        this.safetyRulesToOverride = builder.safetyRulesToOverride;
    }

    public final String routingControlArn() {
        return this.routingControlArn;
    }

    public final RoutingControlState routingControlState() {
        return RoutingControlState.fromValue(this.routingControlState);
    }

    public final String routingControlStateAsString() {
        return this.routingControlState;
    }

    public final boolean hasSafetyRulesToOverride() {
        return this.safetyRulesToOverride != null && !(this.safetyRulesToOverride instanceof SdkAutoConstructList);
    }

    public final List<String> safetyRulesToOverride() {
        return this.safetyRulesToOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingControlStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSafetyRulesToOverride() ? this.safetyRulesToOverride() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingControlStateRequest)) {
            return false;
        }
        UpdateRoutingControlStateRequest other = (UpdateRoutingControlStateRequest)((Object)obj);
        return Objects.equals(this.routingControlArn(), other.routingControlArn()) && Objects.equals(this.routingControlStateAsString(), other.routingControlStateAsString()) && this.hasSafetyRulesToOverride() == other.hasSafetyRulesToOverride() && Objects.equals(this.safetyRulesToOverride(), other.safetyRulesToOverride());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRoutingControlStateRequest").add("RoutingControlArn", (Object)this.routingControlArn()).add("RoutingControlState", (Object)this.routingControlStateAsString()).add("SafetyRulesToOverride", this.hasSafetyRulesToOverride() ? this.safetyRulesToOverride() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingControlArn": {
                return Optional.ofNullable(clazz.cast(this.routingControlArn()));
            }
            case "RoutingControlState": {
                return Optional.ofNullable(clazz.cast(this.routingControlStateAsString()));
            }
            case "SafetyRulesToOverride": {
                return Optional.ofNullable(clazz.cast(this.safetyRulesToOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingControlStateRequest, T> g) {
        return obj -> g.apply((UpdateRoutingControlStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryClusterRequest.BuilderImpl
    implements Builder {
        private String routingControlArn;
        private String routingControlState;
        private List<String> safetyRulesToOverride = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingControlStateRequest model) {
            super(model);
            this.routingControlArn(model.routingControlArn);
            this.routingControlState(model.routingControlState);
            this.safetyRulesToOverride(model.safetyRulesToOverride);
        }

        public final String getRoutingControlArn() {
            return this.routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        @Transient
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        public final String getRoutingControlState() {
            return this.routingControlState;
        }

        public final void setRoutingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
        }

        @Override
        @Transient
        public final Builder routingControlState(String routingControlState) {
            this.routingControlState = routingControlState;
            return this;
        }

        @Override
        @Transient
        public final Builder routingControlState(RoutingControlState routingControlState) {
            this.routingControlState(routingControlState == null ? null : routingControlState.toString());
            return this;
        }

        public final Collection<String> getSafetyRulesToOverride() {
            if (this.safetyRulesToOverride instanceof SdkAutoConstructList) {
                return null;
            }
            return this.safetyRulesToOverride;
        }

        public final void setSafetyRulesToOverride(Collection<String> safetyRulesToOverride) {
            this.safetyRulesToOverride = ArnsCopier.copy(safetyRulesToOverride);
        }

        @Override
        @Transient
        public final Builder safetyRulesToOverride(Collection<String> safetyRulesToOverride) {
            this.safetyRulesToOverride = ArnsCopier.copy(safetyRulesToOverride);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder safetyRulesToOverride(String ... safetyRulesToOverride) {
            this.safetyRulesToOverride(Arrays.asList(safetyRulesToOverride));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingControlStateRequest build() {
            return new UpdateRoutingControlStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53RecoveryClusterRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRoutingControlStateRequest> {
        public Builder routingControlArn(String var1);

        public Builder routingControlState(String var1);

        public Builder routingControlState(RoutingControlState var1);

        public Builder safetyRulesToOverride(Collection<String> var1);

        public Builder safetyRulesToOverride(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

