/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53profiles.Route53ProfilesClient;
import software.amazon.awssdk.services.route53profiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53profiles.model.ListProfilesRequest;
import software.amazon.awssdk.services.route53profiles.model.ListProfilesResponse;
import software.amazon.awssdk.services.route53profiles.model.ProfileSummary;

public class ListProfilesIterable
implements SdkIterable<ListProfilesResponse> {
    private final Route53ProfilesClient client;
    private final ListProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfilesIterable(Route53ProfilesClient client, ListProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProfilesResponseFetcher();
    }

    public Iterator<ListProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProfileSummary> profileSummaries() {
        Function<ListProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileSummaries() != null) {
                return response.profileSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProfilesResponseFetcher
    implements SyncPageFetcher<ListProfilesResponse> {
        private ListProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfilesResponse nextPage(ListProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListProfilesIterable.this.client.listProfiles(ListProfilesIterable.this.firstRequest);
            }
            return ListProfilesIterable.this.client.listProfiles((ListProfilesRequest)((Object)ListProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

