/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53profiles.model.ProfileStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileResourceAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileResourceAssociation> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::creationTime)).setter(ProfileResourceAssociation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::id)).setter(ProfileResourceAssociation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModificationTime").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::modificationTime)).setter(ProfileResourceAssociation.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::name)).setter(ProfileResourceAssociation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::ownerId)).setter(ProfileResourceAssociation.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::profileId)).setter(ProfileResourceAssociation.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::resourceArn)).setter(ProfileResourceAssociation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceProperties").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::resourceProperties)).setter(ProfileResourceAssociation.setter(Builder::resourceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceProperties").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::resourceType)).setter(ProfileResourceAssociation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::statusAsString)).setter(ProfileResourceAssociation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ProfileResourceAssociation.getter(ProfileResourceAssociation::statusMessage)).setter(ProfileResourceAssociation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, ID_FIELD, MODIFICATION_TIME_FIELD, NAME_FIELD, OWNER_ID_FIELD, PROFILE_ID_FIELD, RESOURCE_ARN_FIELD, RESOURCE_PROPERTIES_FIELD, RESOURCE_TYPE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("Id", ID_FIELD);
            this.put("ModificationTime", MODIFICATION_TIME_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("ProfileId", PROFILE_ID_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("ResourceProperties", RESOURCE_PROPERTIES_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String id;
    private final Instant modificationTime;
    private final String name;
    private final String ownerId;
    private final String profileId;
    private final String resourceArn;
    private final String resourceProperties;
    private final String resourceType;
    private final String status;
    private final String statusMessage;

    private ProfileResourceAssociation(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.modificationTime = builder.modificationTime;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.profileId = builder.profileId;
        this.resourceArn = builder.resourceArn;
        this.resourceProperties = builder.resourceProperties;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final Instant modificationTime() {
        return this.modificationTime;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceProperties() {
        return this.resourceProperties;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final ProfileStatus status() {
        return ProfileStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileResourceAssociation)) {
            return false;
        }
        ProfileResourceAssociation other = (ProfileResourceAssociation)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.modificationTime(), other.modificationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceProperties(), other.resourceProperties()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileResourceAssociation").add("CreationTime", (Object)this.creationTime()).add("Id", (Object)this.id()).add("ModificationTime", (Object)this.modificationTime()).add("Name", (Object)this.name()).add("OwnerId", (Object)this.ownerId()).add("ProfileId", (Object)this.profileId()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceProperties", (Object)this.resourceProperties()).add("ResourceType", (Object)this.resourceType()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceProperties": {
                return Optional.ofNullable(clazz.cast(this.resourceProperties()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProfileResourceAssociation, T> g) {
        return obj -> g.apply((ProfileResourceAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String id;
        private Instant modificationTime;
        private String name;
        private String ownerId;
        private String profileId;
        private String resourceArn;
        private String resourceProperties;
        private String resourceType;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileResourceAssociation model) {
            this.creationTime(model.creationTime);
            this.id(model.id);
            this.modificationTime(model.modificationTime);
            this.name(model.name);
            this.ownerId(model.ownerId);
            this.profileId(model.profileId);
            this.resourceArn(model.resourceArn);
            this.resourceProperties(model.resourceProperties);
            this.resourceType(model.resourceType);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getModificationTime() {
            return this.modificationTime;
        }

        public final void setModificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceProperties() {
            return this.resourceProperties;
        }

        public final void setResourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public final Builder resourceProperties(String resourceProperties) {
            this.resourceProperties = resourceProperties;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public ProfileResourceAssociation build() {
            return new ProfileResourceAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileResourceAssociation> {
        public Builder creationTime(Instant var1);

        public Builder id(String var1);

        public Builder modificationTime(Instant var1);

        public Builder name(String var1);

        public Builder ownerId(String var1);

        public Builder profileId(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceProperties(String var1);

        public Builder resourceType(String var1);

        public Builder status(String var1);

        public Builder status(ProfileStatus var1);

        public Builder statusMessage(String var1);
    }
}

