/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProfileResourceStatus {
    CREATING("CREATING"),
    OPERATIONAL("OPERATIONAL"),
    UPDATING("UPDATING"),
    ENABLING("ENABLING"),
    DISABLING("DISABLING"),
    DISABLED("DISABLED"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProfileResourceStatus> VALUE_MAP;
    private final String value;

    private ProfileResourceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProfileResourceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProfileResourceStatus> knownValues() {
        EnumSet<ProfileResourceStatus> knownValues = EnumSet.allOf(ProfileResourceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProfileResourceStatus.class, ProfileResourceStatus::toString);
    }
}

