/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.AccessSourcesCopier;
import software.amazon.awssdk.services.route53globalresolver.model.AccessSourcesItem;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessSourcesResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, ListAccessSourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccessSourcesResponse.getter(ListAccessSourcesResponse::nextToken)).setter(ListAccessSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AccessSourcesItem>> ACCESS_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessSources").getter(ListAccessSourcesResponse.getter(ListAccessSourcesResponse::accessSources)).setter(ListAccessSourcesResponse.setter(Builder::accessSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessSourcesItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ACCESS_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccessSourcesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AccessSourcesItem> accessSources;

    private ListAccessSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessSources = builder.accessSources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAccessSources() {
        return this.accessSources != null && !(this.accessSources instanceof SdkAutoConstructList);
    }

    public final List<AccessSourcesItem> accessSources() {
        return this.accessSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessSources() ? this.accessSources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessSourcesResponse)) {
            return false;
        }
        ListAccessSourcesResponse other = (ListAccessSourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAccessSources() == other.hasAccessSources() && Objects.equals(this.accessSources(), other.accessSources());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessSourcesResponse").add("NextToken", (Object)this.nextToken()).add("AccessSources", this.hasAccessSources() ? this.accessSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "accessSources": {
                return Optional.ofNullable(clazz.cast(this.accessSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("accessSources", ACCESS_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessSourcesResponse, T> g) {
        return obj -> g.apply((ListAccessSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AccessSourcesItem> accessSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessSourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.accessSources(model.accessSources);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AccessSourcesItem.Builder> getAccessSources() {
            List<AccessSourcesItem.Builder> result = AccessSourcesCopier.copyToBuilder(this.accessSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessSources(Collection<AccessSourcesItem.BuilderImpl> accessSources) {
            this.accessSources = AccessSourcesCopier.copyFromBuilder(accessSources);
        }

        @Override
        public final Builder accessSources(Collection<AccessSourcesItem> accessSources) {
            this.accessSources = AccessSourcesCopier.copy(accessSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessSources(AccessSourcesItem ... accessSources) {
            this.accessSources(Arrays.asList(accessSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessSources(Consumer<AccessSourcesItem.Builder> ... accessSources) {
            this.accessSources(Stream.of(accessSources).map(c -> (AccessSourcesItem)((AccessSourcesItem.Builder)AccessSourcesItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessSourcesResponse build() {
            return new ListAccessSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessSourcesResponse> {
        public Builder nextToken(String var1);

        public Builder accessSources(Collection<AccessSourcesItem> var1);

        public Builder accessSources(AccessSourcesItem ... var1);

        public Builder accessSources(Consumer<AccessSourcesItem.Builder> ... var1);
    }
}

