/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53globalresolver.model.CRResourceStatus;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFirewallDomainListResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, CreateFirewallDomainListResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::arn)).setter(CreateFirewallDomainListResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> GLOBAL_RESOLVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("globalResolverId").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::globalResolverId)).setter(CreateFirewallDomainListResponse.setter(Builder::globalResolverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalResolverId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::createdAt)).setter(CreateFirewallDomainListResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::description)).setter(CreateFirewallDomainListResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> DOMAIN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("domainCount").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::domainCount)).setter(CreateFirewallDomainListResponse.setter(Builder::domainCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainCount").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::id)).setter(CreateFirewallDomainListResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::name)).setter(CreateFirewallDomainListResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::statusAsString)).setter(CreateFirewallDomainListResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(CreateFirewallDomainListResponse.getter(CreateFirewallDomainListResponse::updatedAt)).setter(CreateFirewallDomainListResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, GLOBAL_RESOLVER_ID_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DOMAIN_COUNT_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFirewallDomainListResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String globalResolverId;
    private final Instant createdAt;
    private final String description;
    private final Integer domainCount;
    private final String id;
    private final String name;
    private final String status;
    private final Instant updatedAt;

    private CreateFirewallDomainListResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.globalResolverId = builder.globalResolverId;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.domainCount = builder.domainCount;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String globalResolverId() {
        return this.globalResolverId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final Integer domainCount() {
        return this.domainCount;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final CRResourceStatus status() {
        return CRResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallDomainListResponse)) {
            return false;
        }
        CreateFirewallDomainListResponse other = (CreateFirewallDomainListResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.globalResolverId(), other.globalResolverId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainCount(), other.domainCount()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFirewallDomainListResponse").add("Arn", (Object)this.arn()).add("GlobalResolverId", (Object)this.globalResolverId()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("DomainCount", (Object)this.domainCount()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "globalResolverId": {
                return Optional.ofNullable(clazz.cast(this.globalResolverId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainCount": {
                return Optional.ofNullable(clazz.cast(this.domainCount()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("globalResolverId", GLOBAL_RESOLVER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainCount", DOMAIN_COUNT_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallDomainListResponse, T> g) {
        return obj -> g.apply((CreateFirewallDomainListResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String globalResolverId;
        private Instant createdAt;
        private String description;
        private Integer domainCount;
        private String id;
        private String name;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallDomainListResponse model) {
            super(model);
            this.arn(model.arn);
            this.globalResolverId(model.globalResolverId);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.domainCount(model.domainCount);
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getGlobalResolverId() {
            return this.globalResolverId;
        }

        public final void setGlobalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
        }

        @Override
        public final Builder globalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDomainCount() {
            return this.domainCount;
        }

        public final void setDomainCount(Integer domainCount) {
            this.domainCount = domainCount;
        }

        @Override
        public final Builder domainCount(Integer domainCount) {
            this.domainCount = domainCount;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CRResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public CreateFirewallDomainListResponse build() {
            return new CreateFirewallDomainListResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFirewallDomainListResponse> {
        public Builder arn(String var1);

        public Builder globalResolverId(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder domainCount(Integer var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(CRResourceStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

