/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallDomainListsCopier;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallDomainListsItem;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFirewallDomainListsResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, ListFirewallDomainListsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFirewallDomainListsResponse.getter(ListFirewallDomainListsResponse::nextToken)).setter(ListFirewallDomainListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<FirewallDomainListsItem>> FIREWALL_DOMAIN_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("firewallDomainLists").getter(ListFirewallDomainListsResponse.getter(ListFirewallDomainListsResponse::firewallDomainLists)).setter(ListFirewallDomainListsResponse.setter(Builder::firewallDomainLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallDomainLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallDomainListsItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FIREWALL_DOMAIN_LISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFirewallDomainListsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<FirewallDomainListsItem> firewallDomainLists;

    private ListFirewallDomainListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallDomainLists = builder.firewallDomainLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFirewallDomainLists() {
        return this.firewallDomainLists != null && !(this.firewallDomainLists instanceof SdkAutoConstructList);
    }

    public final List<FirewallDomainListsItem> firewallDomainLists() {
        return this.firewallDomainLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewallDomainLists() ? this.firewallDomainLists() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallDomainListsResponse)) {
            return false;
        }
        ListFirewallDomainListsResponse other = (ListFirewallDomainListsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFirewallDomainLists() == other.hasFirewallDomainLists() && Objects.equals(this.firewallDomainLists(), other.firewallDomainLists());
    }

    public final String toString() {
        return ToString.builder((String)"ListFirewallDomainListsResponse").add("NextToken", (Object)this.nextToken()).add("FirewallDomainLists", this.hasFirewallDomainLists() ? this.firewallDomainLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "firewallDomainLists": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainLists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("firewallDomainLists", FIREWALL_DOMAIN_LISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallDomainListsResponse, T> g) {
        return obj -> g.apply((ListFirewallDomainListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FirewallDomainListsItem> firewallDomainLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallDomainListsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.firewallDomainLists(model.firewallDomainLists);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallDomainListsItem.Builder> getFirewallDomainLists() {
            List<FirewallDomainListsItem.Builder> result = FirewallDomainListsCopier.copyToBuilder(this.firewallDomainLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallDomainLists(Collection<FirewallDomainListsItem.BuilderImpl> firewallDomainLists) {
            this.firewallDomainLists = FirewallDomainListsCopier.copyFromBuilder(firewallDomainLists);
        }

        @Override
        public final Builder firewallDomainLists(Collection<FirewallDomainListsItem> firewallDomainLists) {
            this.firewallDomainLists = FirewallDomainListsCopier.copy(firewallDomainLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallDomainLists(FirewallDomainListsItem ... firewallDomainLists) {
            this.firewallDomainLists(Arrays.asList(firewallDomainLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallDomainLists(Consumer<FirewallDomainListsItem.Builder> ... firewallDomainLists) {
            this.firewallDomainLists(Stream.of(firewallDomainLists).map(c -> (FirewallDomainListsItem)((FirewallDomainListsItem.Builder)FirewallDomainListsItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallDomainListsResponse build() {
            return new ListFirewallDomainListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFirewallDomainListsResponse> {
        public Builder nextToken(String var1);

        public Builder firewallDomainLists(Collection<FirewallDomainListsItem> var1);

        public Builder firewallDomainLists(FirewallDomainListsItem ... var1);

        public Builder firewallDomainLists(Consumer<FirewallDomainListsItem.Builder> ... var1);
    }
}

