/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53globalresolver.model.FiltersCopier;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessSourcesRequest
extends Route53GlobalResolverRequest
implements ToCopyableBuilder<Builder, ListAccessSourcesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAccessSourcesRequest.getter(ListAccessSourcesRequest::maxResults)).setter(ListAccessSourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max_results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccessSourcesRequest.getter(ListAccessSourcesRequest::nextToken)).setter(ListAccessSourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next_token").build()}).build();
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("filters").getter(ListAccessSourcesRequest.getter(ListAccessSourcesRequest::filters)).setter(ListAccessSourcesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccessSourcesRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final Map<String, List<String>> filters;

    private ListAccessSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessSourcesRequest)) {
            return false;
        }
        ListAccessSourcesRequest other = (ListAccessSourcesRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessSourcesRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("max_results", MAX_RESULTS_FIELD);
        map.put("next_token", NEXT_TOKEN_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessSourcesRequest, T> g) {
        return obj -> g.apply((ListAccessSourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessSourcesRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.filters(model.filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (this.filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FiltersCopier.copy(filters);
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessSourcesRequest build() {
            return new ListAccessSourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessSourcesRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder filters(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

