/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleOutputItem;
import software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleOutputItemsCopier;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteFirewallRuleResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, BatchDeleteFirewallRuleResponse> {
    private static final SdkField<List<BatchDeleteFirewallRuleOutputItem>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(BatchDeleteFirewallRuleResponse.getter(BatchDeleteFirewallRuleResponse::failures)).setter(BatchDeleteFirewallRuleResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteFirewallRuleOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchDeleteFirewallRuleOutputItem>> SUCCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successes").getter(BatchDeleteFirewallRuleResponse.getter(BatchDeleteFirewallRuleResponse::successes)).setter(BatchDeleteFirewallRuleResponse.setter(Builder::successes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteFirewallRuleOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURES_FIELD, SUCCESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteFirewallRuleResponse.memberNameToFieldInitializer();
    private final List<BatchDeleteFirewallRuleOutputItem> failures;
    private final List<BatchDeleteFirewallRuleOutputItem> successes;

    private BatchDeleteFirewallRuleResponse(BuilderImpl builder) {
        super(builder);
        this.failures = builder.failures;
        this.successes = builder.successes;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteFirewallRuleOutputItem> failures() {
        return this.failures;
    }

    public final boolean hasSuccesses() {
        return this.successes != null && !(this.successes instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteFirewallRuleOutputItem> successes() {
        return this.successes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccesses() ? this.successes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteFirewallRuleResponse)) {
            return false;
        }
        BatchDeleteFirewallRuleResponse other = (BatchDeleteFirewallRuleResponse)((Object)obj);
        return this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures()) && this.hasSuccesses() == other.hasSuccesses() && Objects.equals(this.successes(), other.successes());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteFirewallRuleResponse").add("Failures", this.hasFailures() ? this.failures() : null).add("Successes", this.hasSuccesses() ? this.successes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
            case "successes": {
                return Optional.ofNullable(clazz.cast(this.successes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BatchDeleteFirewallRuleOutputItem>>> map = new HashMap<String, SdkField<List<BatchDeleteFirewallRuleOutputItem>>>();
        map.put("failures", FAILURES_FIELD);
        map.put("successes", SUCCESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteFirewallRuleResponse, T> g) {
        return obj -> g.apply((BatchDeleteFirewallRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private List<BatchDeleteFirewallRuleOutputItem> failures = DefaultSdkAutoConstructList.getInstance();
        private List<BatchDeleteFirewallRuleOutputItem> successes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteFirewallRuleResponse model) {
            super(model);
            this.failures(model.failures);
            this.successes(model.successes);
        }

        public final List<BatchDeleteFirewallRuleOutputItem.Builder> getFailures() {
            List<BatchDeleteFirewallRuleOutputItem.Builder> result = BatchDeleteFirewallRuleOutputItemsCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<BatchDeleteFirewallRuleOutputItem.BuilderImpl> failures) {
            this.failures = BatchDeleteFirewallRuleOutputItemsCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<BatchDeleteFirewallRuleOutputItem> failures) {
            this.failures = BatchDeleteFirewallRuleOutputItemsCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(BatchDeleteFirewallRuleOutputItem ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<BatchDeleteFirewallRuleOutputItem.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (BatchDeleteFirewallRuleOutputItem)((BatchDeleteFirewallRuleOutputItem.Builder)BatchDeleteFirewallRuleOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchDeleteFirewallRuleOutputItem.Builder> getSuccesses() {
            List<BatchDeleteFirewallRuleOutputItem.Builder> result = BatchDeleteFirewallRuleOutputItemsCopier.copyToBuilder(this.successes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccesses(Collection<BatchDeleteFirewallRuleOutputItem.BuilderImpl> successes) {
            this.successes = BatchDeleteFirewallRuleOutputItemsCopier.copyFromBuilder(successes);
        }

        @Override
        public final Builder successes(Collection<BatchDeleteFirewallRuleOutputItem> successes) {
            this.successes = BatchDeleteFirewallRuleOutputItemsCopier.copy(successes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successes(BatchDeleteFirewallRuleOutputItem ... successes) {
            this.successes(Arrays.asList(successes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successes(Consumer<BatchDeleteFirewallRuleOutputItem.Builder> ... successes) {
            this.successes(Stream.of(successes).map(c -> (BatchDeleteFirewallRuleOutputItem)((BatchDeleteFirewallRuleOutputItem.Builder)BatchDeleteFirewallRuleOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteFirewallRuleResponse build() {
            return new BatchDeleteFirewallRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteFirewallRuleResponse> {
        public Builder failures(Collection<BatchDeleteFirewallRuleOutputItem> var1);

        public Builder failures(BatchDeleteFirewallRuleOutputItem ... var1);

        public Builder failures(Consumer<BatchDeleteFirewallRuleOutputItem.Builder> ... var1);

        public Builder successes(Collection<BatchDeleteFirewallRuleOutputItem> var1);

        public Builder successes(BatchDeleteFirewallRuleOutputItem ... var1);

        public Builder successes(Consumer<BatchDeleteFirewallRuleOutputItem.Builder> ... var1);
    }
}

